/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.Channel;
import org.apache.activeio.adapter.SyncToAsyncChannel;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;
import org.apache.activeio.packet.sync.SyncChannel;

public final class AsyncToSyncChannel
implements SyncChannel,
AsyncChannelListener {
    private final AsyncChannel asyncChannel;
    private final BlockingQueue buffer;

    public static SyncChannel adapt(Channel channel) {
        return AsyncToSyncChannel.adapt(channel, (BlockingQueue)new LinkedBlockingQueue());
    }

    public static SyncChannel adapt(Channel channel, BlockingQueue upPacketChannel) {
        if (channel instanceof SyncChannel) {
            return (SyncChannel)channel;
        }
        if (channel.getClass() == SyncToAsyncChannel.class) {
            return ((SyncToAsyncChannel)channel).getSynchChannel();
        }
        return new AsyncToSyncChannel((AsyncChannel)channel, upPacketChannel);
    }

    public AsyncToSyncChannel(AsyncChannel asyncChannel) {
        this(asyncChannel, (BlockingQueue)new LinkedBlockingQueue());
    }

    public AsyncToSyncChannel(AsyncChannel asyncChannel, BlockingQueue upPacketChannel) {
        this.asyncChannel = asyncChannel;
        this.asyncChannel.setAsyncChannelListener(this);
        this.buffer = upPacketChannel;
    }

    public void write(Packet packet) throws IOException {
        this.asyncChannel.write(packet);
    }

    public void flush() throws IOException {
        this.asyncChannel.flush();
    }

    public Packet read(long timeout) throws IOException {
        try {
            Object o = timeout == 0L ? this.buffer.poll(0L, TimeUnit.MILLISECONDS) : (timeout == -1L ? this.buffer.take() : this.buffer.poll(timeout, TimeUnit.MILLISECONDS));
            if (o == null) {
                return null;
            }
            if (o instanceof Packet) {
                return (Packet)o;
            }
            Throwable e = (Throwable)o;
            throw (IOException)new IOException("Async error occurred: " + e).initCause(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public void dispose() {
        this.asyncChannel.dispose();
    }

    public void start() throws IOException {
        this.asyncChannel.start();
    }

    public void stop() throws IOException {
        this.asyncChannel.stop();
    }

    public void onPacket(Packet packet) {
        try {
            this.buffer.put((Object)packet);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onPacketError(IOException error) {
        try {
            this.buffer.put((Object)error);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.asyncChannel.getAdapter(target);
    }

    public AsyncChannel getAsyncChannel() {
        return this.asyncChannel;
    }

    public String toString() {
        return this.asyncChannel.toString();
    }
}

