/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.Channel;
import org.apache.activeio.ChannelServer;
import org.apache.activeio.adapter.SyncToAsyncChannel;
import org.apache.activeio.adapter.SyncToAsyncChannelServer;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.sync.SyncChannelServer;

public final class AsyncToSyncChannelServer
implements SyncChannelServer,
AcceptListener {
    private final AsyncChannelServer asyncChannelServer;
    private final BlockingQueue acceptBuffer;

    public static SyncChannelServer adapt(ChannelServer channel) {
        return AsyncToSyncChannelServer.adapt(channel, (BlockingQueue)new LinkedBlockingQueue());
    }

    public static SyncChannelServer adapt(ChannelServer channel, BlockingQueue upPacketChannel) {
        if (channel instanceof SyncChannelServer) {
            return (SyncChannelServer)channel;
        }
        if (channel.getClass() == SyncToAsyncChannel.class) {
            return ((SyncToAsyncChannelServer)channel).getSynchChannelServer();
        }
        return new AsyncToSyncChannelServer((AsyncChannelServer)channel, upPacketChannel);
    }

    public AsyncToSyncChannelServer(AsyncChannelServer asyncChannelServer) {
        this(asyncChannelServer, (BlockingQueue)new LinkedBlockingQueue());
    }

    public AsyncToSyncChannelServer(AsyncChannelServer asyncChannelServer, BlockingQueue acceptBuffer) {
        this.asyncChannelServer = asyncChannelServer;
        this.acceptBuffer = acceptBuffer;
        this.asyncChannelServer.setAcceptListener(this);
    }

    public Channel accept(long timeout) throws IOException {
        try {
            Object o = timeout == 0L ? this.acceptBuffer.poll(0L, TimeUnit.MILLISECONDS) : (timeout == -1L ? this.acceptBuffer.take() : this.acceptBuffer.poll(timeout, TimeUnit.MILLISECONDS));
            if (o == null) {
                return null;
            }
            if (o instanceof Channel) {
                return (Channel)o;
            }
            Throwable e = (Throwable)o;
            throw (IOException)new IOException("Async error occurred: " + e).initCause(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public void dispose() {
        this.asyncChannelServer.dispose();
    }

    public void start() throws IOException {
        this.asyncChannelServer.start();
    }

    public void stop() throws IOException {
        this.asyncChannelServer.stop();
    }

    public URI getBindURI() {
        return this.asyncChannelServer.getBindURI();
    }

    public URI getConnectURI() {
        return this.asyncChannelServer.getConnectURI();
    }

    public void onAccept(Channel channel) {
        try {
            this.acceptBuffer.put((Object)channel);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onAcceptError(IOException error) {
        try {
            this.acceptBuffer.put((Object)error);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public AsyncChannelServer getAsyncChannelServer() {
        return this.asyncChannelServer;
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.asyncChannelServer.getAdapter(target);
    }

    public String toString() {
        return this.asyncChannelServer.toString();
    }
}

