/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.URI;
import org.apache.activeio.ChannelFactory;
import org.apache.activeio.adapter.AsyncToSyncChannelFactory;
import org.apache.activeio.adapter.SyncToAsyncChannel;
import org.apache.activeio.adapter.SyncToAsyncChannelServer;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.sync.SyncChannelFactory;

public class SyncToAsyncChannelFactory
implements AsyncChannelFactory {
    private final SyncChannelFactory syncChannelFactory;
    private final Executor executor;

    public static AsyncChannelFactory adapt(SyncChannelFactory channelFactory) {
        return SyncToAsyncChannelFactory.adapt(channelFactory, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public static AsyncChannelFactory adapt(SyncChannelFactory channelFactory, Executor executor) {
        if (channelFactory instanceof AsyncChannelFactory) {
            return (AsyncChannelFactory)((Object)channelFactory);
        }
        if (channelFactory.getClass() == AsyncToSyncChannelFactory.class) {
            return ((AsyncToSyncChannelFactory)channelFactory).getAsyncChannelFactory();
        }
        return new SyncToAsyncChannelFactory(channelFactory, executor);
    }

    public SyncToAsyncChannelFactory(SyncChannelFactory next) {
        this(next, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public SyncToAsyncChannelFactory(SyncChannelFactory next, Executor executor) {
        this.syncChannelFactory = next;
        this.executor = executor;
    }

    public AsyncChannel openAsyncChannel(URI location) throws IOException {
        return SyncToAsyncChannel.adapt(this.syncChannelFactory.openSyncChannel(location), this.executor);
    }

    public AsyncChannelServer bindAsyncChannel(URI location) throws IOException {
        return new SyncToAsyncChannelServer(this.syncChannelFactory.bindSyncChannel(location), this.executor);
    }

    public SyncChannelFactory getSyncChannelFactory() {
        return this.syncChannelFactory;
    }
}

