/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import org.apache.activeio.packet.FilterPacket;
import org.apache.activeio.packet.Packet;

public abstract class PacketPool {
    public static final int DEFAULT_POOL_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.journal.active.DefaultPoolSize", "5"));
    public static final int DEFAULT_PACKET_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.journal.active.DefaultPacketSize", "4194304"));
    private final ArrayList pool = new ArrayList();
    private final int maxPackets;
    private int currentPoolSize;
    private boolean disposed;

    public PacketPool(int maxPackets) {
        this.maxPackets = maxPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getPacket() throws InterruptedException {
        Packet answer = null;
        PacketPool packetPool = this;
        synchronized (packetPool) {
            while (answer == null) {
                if (this.disposed) {
                    return null;
                }
                if (this.pool.size() > 0) {
                    answer = (Packet)this.pool.remove(this.pool.size() - 1);
                } else if (this.currentPoolSize < this.maxPackets) {
                    answer = this.allocateNewPacket();
                    ++this.currentPoolSize;
                }
                if (answer != null) continue;
                this.wait();
            }
        }
        return new PooledPacket(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnPacket(Packet packet) {
        packet.clear();
        PacketPool packetPool = this;
        synchronized (packetPool) {
            this.pool.add(packet);
            this.notify();
        }
    }

    public synchronized void dispose() {
        this.disposed = true;
        while (this.currentPoolSize > 0) {
            if (this.pool.size() > 0) {
                this.currentPoolSize -= this.pool.size();
                this.pool.clear();
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void waitForPacketsToReturn() {
        while (this.currentPoolSize != this.pool.size()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected abstract Packet allocateNewPacket();

    public class PooledPacket
    extends FilterPacket {
        private final AtomicInteger referenceCounter;

        public PooledPacket(Packet next) {
            this(next, new AtomicInteger(0));
        }

        private PooledPacket(Packet next, AtomicInteger referenceCounter) {
            super(next);
            this.referenceCounter = referenceCounter;
            this.referenceCounter.incrementAndGet();
        }

        public Packet filter(Packet packet) {
            return new PooledPacket(this.next, this.referenceCounter);
        }

        int getReferenceCounter() {
            return this.referenceCounter.get();
        }

        public void dispose() {
            if (this.referenceCounter.decrementAndGet() == 0) {
                PacketPool.this.returnPacket(this.next);
            }
        }
    }
}

