/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.filter;

import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;

public class SynchornizedAsyncChannel
extends FilterAsyncChannel {
    private final Lock writeLock;

    public SynchornizedAsyncChannel(AsyncChannel next) {
        this(next, (Lock)new ReentrantLock());
    }

    public SynchornizedAsyncChannel(AsyncChannel next, Lock writeLock) {
        super(next);
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Packet packet) throws IOException {
        this.writeLock.lock();
        try {
            this.getNext().write(packet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.writeLock.lock();
        try {
            this.getNext().flush();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized Object getAdapter(Class target) {
        return super.getAdapter(target);
    }

    public synchronized void start() throws IOException {
        super.start();
    }

    public synchronized void stop() throws IOException {
        super.stop();
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }
}

