/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.nio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.activeio.ChannelFactory;

public final class NIOAsyncChannelSelectorManager {
    private static Executor selectorExecutor = ChannelFactory.DEFAULT_EXECUTOR;
    private static Executor channelExecutor = ChannelFactory.DEFAULT_EXECUTOR;
    private static LinkedList freeManagers = new LinkedList();
    private static LinkedList fullManagers = new LinkedList();
    private static final int MAX_CHANNELS_PER_SELECTOR = 50;
    private Selector selector;
    private int useCounter;
    private int id = NIOAsyncChannelSelectorManager.getNextId();
    private static int nextId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SocketChannelAsyncChannelSelection register(SocketChannel socketChannel, SelectorManagerListener listener) throws IOException {
        NIOAsyncChannelSelectorManager manager = null;
        LinkedList linkedList = freeManagers;
        synchronized (linkedList) {
            if (freeManagers.size() > 0) {
                manager = (NIOAsyncChannelSelectorManager)freeManagers.getFirst();
            }
            if (manager == null) {
                manager = new NIOAsyncChannelSelectorManager();
                freeManagers.addFirst(manager);
            }
            NIOAsyncChannelSelectorManager nIOAsyncChannelSelectorManager = manager;
            nIOAsyncChannelSelectorManager.getClass();
            SocketChannelAsyncChannelSelection selection = nIOAsyncChannelSelectorManager.new SocketChannelAsyncChannelSelection(socketChannel, listener);
            if (manager.useCounter >= 50) {
                freeManagers.removeFirst();
                fullManagers.addLast(manager);
            }
            return selection;
        }
    }

    public static synchronized void setSelectorExecutor(Executor executor) {
        selectorExecutor = executor;
    }

    public static synchronized void setChannelExecutor(Executor executor) {
        channelExecutor = executor;
    }

    private NIOAsyncChannelSelectorManager() throws IOException {
        this.selector = Selector.open();
    }

    private static synchronized int getNextId() {
        return nextId++;
    }

    private int getId() {
        return this.id;
    }

    private synchronized void incrementUseCounter() {
        ++this.useCounter;
        if (this.useCounter == 1) {
            selectorExecutor.execute((Runnable)new SelectorWorker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decrementUseCounter() {
        --this.useCounter;
        LinkedList linkedList = freeManagers;
        synchronized (linkedList) {
            if (this.useCounter == 0) {
                freeManagers.remove(this);
            } else if (this.useCounter < 50) {
                fullManagers.remove(this);
                freeManagers.addLast(this);
            }
        }
    }

    private synchronized boolean isRunning() {
        return this.useCounter > 0;
    }

    static {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux")) {
            channelExecutor = new ScheduledThreadPoolExecutor(1);
        }
    }

    private class SelectorWorker
    implements Runnable {
        private SelectorWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String origName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName("Selector Worker: " + NIOAsyncChannelSelectorManager.this.getId());
                while (NIOAsyncChannelSelectorManager.this.isRunning()) {
                    int count = NIOAsyncChannelSelectorManager.this.selector.select(10L);
                    if (count == 0) continue;
                    if (!NIOAsyncChannelSelectorManager.this.isRunning()) {
                        return;
                    }
                    Set<SelectionKey> keys = NIOAsyncChannelSelectorManager.this.selector.selectedKeys();
                    Iterator<SelectionKey> i = keys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        i.remove();
                        if (!key.isValid()) continue;
                        final SocketChannelAsyncChannelSelection s = (SocketChannelAsyncChannelSelection)key.attachment();
                        s.disable();
                        channelExecutor.execute(new Runnable(){

                            public void run() {
                                try {
                                    s.onSelect();
                                    s.enable();
                                }
                                catch (Throwable e) {
                                    System.err.println("ActiveIO unexpected error: ");
                                    e.printStackTrace(System.err);
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Unexpected exception: " + e);
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setName(origName);
            }
        }
    }

    public final class SocketChannelAsyncChannelSelection {
        private final SelectionKey key;
        private final SelectorManagerListener listener;
        private boolean closed;
        private int interest;

        private SocketChannelAsyncChannelSelection(SocketChannel socketChannel, SelectorManagerListener listener) throws ClosedChannelException {
            this.listener = listener;
            this.key = socketChannel.register(NIOAsyncChannelSelectorManager.this.selector, 0, this);
            NIOAsyncChannelSelectorManager.this.incrementUseCounter();
        }

        public void setInterestOps(int ops) {
            if (this.closed) {
                return;
            }
            this.interest = ops;
            this.enable();
        }

        public void enable() {
            if (this.closed) {
                return;
            }
            this.key.interestOps(this.interest);
            NIOAsyncChannelSelectorManager.this.selector.wakeup();
        }

        public void disable() {
            if (this.closed) {
                return;
            }
            this.key.interestOps(0);
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.key.cancel();
            NIOAsyncChannelSelectorManager.this.decrementUseCounter();
            NIOAsyncChannelSelectorManager.this.selector.wakeup();
            this.closed = true;
        }

        public void onSelect() {
            if (!this.key.isValid()) {
                return;
            }
            this.listener.onSelect(this);
        }

        public boolean isWritable() {
            return this.key.isWritable();
        }

        public boolean isReadable() {
            return this.key.isReadable();
        }
    }

    public static interface SelectorManagerListener {
        public void onSelect(SocketChannelAsyncChannelSelection var1);
    }
}

