/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.vmpipe;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannelListener;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.async.vmpipe.VMPipeAsyncChannelServer;

public final class VMPipeAsyncChannelFactory
implements AsyncChannelFactory {
    private static final String SERVER_MAP_LOCATION = VMPipeAsyncChannelFactory.class.getName() + ".SERVER_MAP";
    private static final Map SERVER_MAP;
    private static final ClassLoader MY_CLASSLOADER;
    private boolean forceRefelection;
    static /* synthetic */ Class class$org$apache$activeio$packet$async$AsyncChannelListener;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public AsyncChannel openAsyncChannel(URI location) throws IOException {
        Object server = VMPipeAsyncChannelFactory.lookupServer(location);
        if (!this.forceRefelection && server.getClass() == VMPipeAsyncChannelServer.class) {
            return ((VMPipeAsyncChannelServer)server).connect();
        }
        try {
            Method method = server.getClass().getMethod("connect", new Class[0]);
            Object channel = method.invoke(server, new Object[0]);
            return new ClassloaderAsyncChannelAdapter(channel);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Connection could not be established: " + e).initCause(e);
        }
    }

    public AsyncChannelServer bindAsyncChannel(URI bindURI) throws IOException {
        VMPipeAsyncChannelServer server = new VMPipeAsyncChannelServer(bindURI);
        VMPipeAsyncChannelFactory.bindServer(bindURI, server);
        return server;
    }

    private static Map getServerMap() {
        return SERVER_MAP;
    }

    public static String getServerKeyForURI(URI location) {
        return location.getHost();
    }

    public static void bindServer(URI bindURI, VMPipeAsyncChannelServer server) throws IOException {
        String key = VMPipeAsyncChannelFactory.getServerKeyForURI(bindURI);
        if (VMPipeAsyncChannelFactory.getServerMap().get(key) != null) {
            throw new IOException("Server is allready bound at: " + bindURI);
        }
        VMPipeAsyncChannelFactory.getServerMap().put(key, server);
    }

    public static Object lookupServer(URI location) throws IOException {
        String key = VMPipeAsyncChannelFactory.getServerKeyForURI(location);
        Object server = VMPipeAsyncChannelFactory.getServerMap().get(key);
        if (server == null) {
            throw new IOException("Connection refused.");
        }
        return server;
    }

    public static void unbindServer(URI bindURI) {
        String key = VMPipeAsyncChannelFactory.getServerKeyForURI(bindURI);
        VMPipeAsyncChannelFactory.getServerMap().remove(key);
    }

    public boolean isForceRefelection() {
        return this.forceRefelection;
    }

    public void setForceRefelection(boolean forceRefelection) {
        this.forceRefelection = forceRefelection;
    }

    static {
        Map m = null;
        m = (Map)System.getProperties().get(SERVER_MAP_LOCATION);
        if (m == null) {
            m = Collections.synchronizedMap(new HashMap());
            System.getProperties().put(SERVER_MAP_LOCATION, m);
        }
        SERVER_MAP = m;
        MY_CLASSLOADER = Packet.class.getClassLoader();
    }

    public static class ClassloaderAsyncChannelAdapter
    implements AsyncChannel {
        private final ClassLoader cl;
        private final Object channel;
        private final Method writeMethod;
        private final Method setListenerMethod;
        private final Class listenerClazz;
        private final Class packetClazz;
        private final Object listenerProxy;
        private final Method duplicateMethod;
        private final Method startMethod;
        private final Method stopMethod;
        private final Method disposeMethod;
        private AsyncChannelListener channelListener;

        public ClassloaderAsyncChannelAdapter(Object channel) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
            this.channel = channel;
            Class<?> clazz = channel.getClass();
            this.cl = clazz.getClassLoader();
            this.listenerClazz = this.cl.loadClass((class$org$apache$activeio$packet$async$AsyncChannelListener == null ? (class$org$apache$activeio$packet$async$AsyncChannelListener = VMPipeAsyncChannelFactory.class$("org.apache.activeio.packet.async.AsyncChannelListener")) : class$org$apache$activeio$packet$async$AsyncChannelListener).getName());
            this.packetClazz = this.cl.loadClass((class$org$apache$activeio$packet$Packet == null ? (class$org$apache$activeio$packet$Packet = VMPipeAsyncChannelFactory.class$("org.apache.activeio.packet.Packet")) : class$org$apache$activeio$packet$Packet).getName());
            this.writeMethod = clazz.getMethod("write", this.packetClazz);
            this.startMethod = clazz.getMethod("start", new Class[0]);
            this.stopMethod = clazz.getMethod("stop", new Class[0]);
            this.disposeMethod = clazz.getMethod("dispose", new Class[0]);
            this.setListenerMethod = clazz.getMethod("setAsyncChannelListener", this.listenerClazz);
            this.duplicateMethod = this.packetClazz.getMethod("duplicate", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = VMPipeAsyncChannelFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            ListenerProxyHandler handler = new ListenerProxyHandler();
            this.listenerProxy = Proxy.newProxyInstance(this.cl, new Class[]{this.listenerClazz}, (InvocationHandler)handler);
        }

        public void write(Packet packet) throws IOException {
            this.callIOExceptionMethod(this.writeMethod, new Object[]{packet.duplicate(this.cl)});
        }

        public void setAsyncChannelListener(AsyncChannelListener channelListener) {
            this.channelListener = channelListener;
            this.callMethod(this.setListenerMethod, new Object[]{channelListener == null ? null : this.listenerProxy});
        }

        public AsyncChannelListener getAsyncChannelListener() {
            return this.channelListener;
        }

        public void dispose() {
            this.callMethod(this.disposeMethod, new Object[0]);
        }

        public void start() throws IOException {
            this.callIOExceptionMethod(this.startMethod, new Object[0]);
        }

        public void stop() throws IOException {
            this.callIOExceptionMethod(this.stopMethod, new Object[0]);
        }

        private void callMethod(Method method, Object[] args) {
            try {
                method.invoke(this.channel, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e.getTargetException());
            }
            catch (Throwable e) {
                throw new RuntimeException("Reflexive invocation failed: " + e, e);
            }
        }

        private void callIOExceptionMethod(Method method, Object[] args) throws IOException {
            try {
                method.invoke(this.channel, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)e.getTargetException();
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e.getTargetException());
            }
            catch (Throwable e) {
                throw (IOException)new IOException("Reflexive invocation failed: " + e).initCause(e);
            }
        }

        public Object getAdapter(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public void flush() throws IOException {
        }

        public class ListenerProxyHandler
        implements InvocationHandler {
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                switch (method.getName().length()) {
                    case 8: {
                        Object packet = ClassloaderAsyncChannelAdapter.this.duplicateMethod.invoke(args[0], MY_CLASSLOADER);
                        ClassloaderAsyncChannelAdapter.this.channelListener.onPacket((Packet)packet);
                        break;
                    }
                    case 13: {
                        ClassloaderAsyncChannelAdapter.this.channelListener.onPacketError((IOException)args[0]);
                        break;
                    }
                    default: {
                        ClassloaderAsyncChannelAdapter.this.channelListener.onPacketError(new IOException("Unknown proxy method invocation: " + method.getName()));
                    }
                }
                return null;
            }
        }
    }
}

