/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.nio;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.EmptyPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.nio.NIOBaseChannel;

public final class NIOSyncChannel
extends NIOBaseChannel
implements SyncChannel {
    private ByteBuffer inputByteBuffer;

    protected NIOSyncChannel(SocketChannel socketChannel) throws IOException {
        this(socketChannel, true);
    }

    protected NIOSyncChannel(SocketChannel socketChannel, boolean useDirect) throws IOException {
        super(socketChannel, useDirect);
    }

    public Packet read(long timeout) throws IOException {
        try {
            int size;
            if (timeout == -1L) {
                this.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.setSoTimeout(1);
            } else {
                this.setSoTimeout((int)timeout);
            }
            if (this.inputByteBuffer == null || !this.inputByteBuffer.hasRemaining()) {
                this.inputByteBuffer = this.allocateBuffer();
            }
            if ((size = this.socketChannel.read(this.inputByteBuffer)) == -1) {
                return EOSPacket.EOS_PACKET;
            }
            if (size == 0) {
                return EmptyPacket.EMPTY_PACKET;
            }
            ByteBuffer remaining = this.inputByteBuffer.slice();
            ByteBufferPacket data = new ByteBufferPacket(((ByteBuffer)this.inputByteBuffer.flip()).slice());
            this.inputByteBuffer = remaining;
            return data;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    public void write(Packet packet) throws IOException {
        ByteBuffer data;
        if (packet.getClass() == ByteBufferPacket.class) {
            data = ((ByteBufferPacket)packet).getByteBuffer();
        } else {
            ByteSequence sequence = packet.asByteSequence();
            data = ByteBuffer.wrap(sequence.getData(), sequence.getOffset(), sequence.getLength());
        }
        this.socketChannel.write(data);
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }
}

