/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.filter.WriteBufferedSyncChannel;
import org.apache.activeio.packet.sync.nio.NIOSyncChannel;
import org.apache.activeio.packet.sync.nio.NIOSyncChannelServer;
import org.apache.activeio.util.URISupport;

public class NIOSyncChannelFactory
implements SyncChannelFactory {
    protected static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.net.nio.BufferSize", "65536"));
    protected static final int DEFAULT_BACKLOG = 500;
    boolean useDirectBuffers = true;
    private final boolean createWriteBufferedChannels;
    private int backlog = 500;

    public NIOSyncChannelFactory() {
        this(true);
    }

    public NIOSyncChannelFactory(boolean createWriteBufferedChannels) {
        this.createWriteBufferedChannels = createWriteBufferedChannels;
    }

    public SyncChannel openSyncChannel(URI location) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(location.getHost(), location.getPort()));
        return this.createSynchChannel(channel);
    }

    protected SyncChannel createSynchChannel(SocketChannel socketChannel) throws IOException {
        SyncChannel channel = new NIOSyncChannel(socketChannel);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedSyncChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers));
        }
        return channel;
    }

    public SyncChannelServer bindSyncChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetSocketAddress address = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") || InetAddress.getLocalHost().getHostName().equals(host) ? new InetSocketAddress(bindURI.getPort()) : new InetSocketAddress(bindURI.getHost(), bindURI.getPort());
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(address, this.backlog);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changePort(connectURI, serverSocketChannel.socket().getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could not build connect URI: " + e).initCause(e);
        }
        return new NIOSyncChannelServer(serverSocketChannel, bindURI, connectURI, this.createWriteBufferedChannels, this.useDirectBuffers);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

