/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.apache.activeio.Channel;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.filter.WriteBufferedSyncChannel;
import org.apache.activeio.packet.sync.nio.NIOSyncChannel;
import org.apache.activeio.packet.sync.socket.SocketSyncChannelServer;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;

public class NIOSyncChannelServer
extends SocketSyncChannelServer {
    private final boolean createWriteBufferedChannels;
    private final boolean useDirectBuffers;

    public NIOSyncChannelServer(ServerSocketChannel socketChannel, URI bindURI, URI connectURI, boolean createWriteBufferedChannels, boolean useDirectBuffers) {
        super(socketChannel.socket(), bindURI, connectURI);
        this.createWriteBufferedChannels = createWriteBufferedChannels;
        this.useDirectBuffers = useDirectBuffers;
    }

    protected Channel createChannel(SocketStreamChannel c) throws IOException {
        SyncChannel channel = new NIOSyncChannel(c.getSocket().getChannel());
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedSyncChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers));
        }
        return channel;
    }
}

