/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.EmptyPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;

public class SocketSyncChannel
implements SyncChannel {
    protected static final int DEFAULT_BUFFER_SIZE = 65536;
    private final SocketStreamChannel channel;
    private Packet inputPacket;
    private final OutputStream os;
    private final InputStream is;

    protected SocketSyncChannel(Socket socket) throws IOException {
        this(new SocketStreamChannel(socket));
    }

    public SocketSyncChannel(SocketStreamChannel channel) throws IOException {
        this.channel = channel;
        this.os = channel.getOutputStream();
        this.is = channel.getInputStream();
        channel.setReceiveBufferSize(65536);
        channel.setSendBufferSize(65536);
    }

    public synchronized Packet read(long timeout) throws IOException {
        try {
            ByteSequence sequence;
            int size;
            if (timeout == -1L) {
                this.channel.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.channel.setSoTimeout(1);
            } else {
                this.channel.setSoTimeout((int)timeout);
            }
            if (this.inputPacket == null || !this.inputPacket.hasRemaining()) {
                this.inputPacket = this.allocatePacket();
            }
            if ((size = this.is.read((sequence = this.inputPacket.asByteSequence()).getData(), sequence.getOffset(), sequence.getLength())) == -1) {
                return EOSPacket.EOS_PACKET;
            }
            if (size == 0) {
                return EmptyPacket.EMPTY_PACKET;
            }
            this.inputPacket.position(size);
            Packet remaining = this.inputPacket.slice();
            this.inputPacket.flip();
            Packet data = this.inputPacket.slice();
            this.inputPacket = remaining;
            return data;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    private Packet allocatePacket() {
        byte[] data = new byte[65536];
        return new ByteArrayPacket(data);
    }

    public void write(Packet packet) throws IOException {
        packet.writeTo(this.os);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void dispose() {
        this.channel.dispose();
    }

    public void start() throws IOException {
        this.channel.start();
    }

    public void stop() throws IOException {
        this.channel.stop();
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.channel.getAdapter(target);
    }

    public String toString() {
        return this.channel.toString();
    }
}

