/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceException;
import org.apache.activeio.xnet.SocketService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDaemon
implements ServerService {
    private static final Log log = LogFactory.getLog((Class)ServiceDaemon.class);
    private final SocketService socketService;
    private final InetAddress address;
    private int port;
    private SocketListener socketListener;
    private int timeout;
    private String name;

    public ServiceDaemon(SocketService socketService, InetAddress address, int port) {
        this(null, socketService, address, port);
    }

    public ServiceDaemon(String name, SocketService socketService, InetAddress address, int port) {
        this.name = name;
        if (socketService == null) {
            throw new IllegalArgumentException("socketService is null");
        }
        this.socketService = socketService;
        this.address = address;
        this.port = port;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.socketListener != null) {
            this.socketListener.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws IOException {
        if (this.socketListener == null) {
            return 0;
        }
        return this.socketListener.getSoTimeout();
    }

    public String getServiceName() {
        return this.socketService.getName();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void init(Properties props) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            ServerSocket serverSocket;
            if (this.socketListener != null) {
                return;
            }
            try {
                serverSocket = new ServerSocket(this.port, 20, this.address);
                this.port = serverSocket.getLocalPort();
                serverSocket.setSoTimeout(this.timeout);
            }
            catch (Exception e) {
                throw new ServiceException("Service failed to open socket", e);
            }
            this.socketListener = new SocketListener(this.socketService, serverSocket);
            Thread thread = new Thread(this.socketListener);
            thread.setName("service." + this.name + "@" + this.socketListener.hashCode());
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            if (this.socketListener != null) {
                this.socketListener.stop();
                this.socketListener = null;
            }
        }
    }

    public String getIP() {
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getName() {
        return null;
    }

    private static class SocketListener
    implements Runnable {
        private SocketService serverService;
        private ServerSocket serverSocket;
        private boolean stopped;

        public SocketListener(SocketService serverService, ServerSocket serverSocket) {
            this.serverService = serverService;
            this.serverSocket = serverSocket;
            this.stopped = false;
        }

        public synchronized void stop() {
            this.stopped = true;
        }

        private synchronized boolean shouldStop() {
            return this.stopped;
        }

        public void run() {
            while (!this.shouldStop()) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    socket.setTcpNoDelay(true);
                    if (this.shouldStop()) continue;
                    this.serverService.service(socket);
                }
                catch (SocketTimeoutException e) {
                }
                catch (Throwable e) {
                    log.error((Object)"Unexpected error", e);
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioException) {
                    log.debug((Object)"Error cleaning up socked", (Throwable)ioException);
                }
                this.serverSocket = null;
            }
            this.serverService = null;
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        public int getSoTimeout() throws IOException {
            return this.serverSocket.getSoTimeout();
        }
    }
}

