/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.memory;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.memory.MemoryStore;

public class TimeoutMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog(TimeoutMemoryStore.class);
    private ConcurrentMap<String, Entry> datas = new ConcurrentHashMap<String, Entry>();
    private final long timeout;

    protected TimeoutMemoryStore(IdGenerator idGenerator, long timeout) {
        super(idGenerator);
        this.timeout = timeout;
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug((Object)("Storing object with id: " + id));
        this.datas.put(id, new Entry(data));
    }

    public Object load(String id) throws IOException {
        this.evict();
        LOG.debug((Object)("Loading object with id:" + id));
        Entry entry = (Entry)this.datas.remove(id);
        return entry == null ? null : entry.data;
    }

    private void evict() {
        long now = System.currentTimeMillis();
        for (String key : this.datas.keySet()) {
            long age = now - ((Entry)this.datas.get((Object)key)).time;
            if (age <= this.timeout) continue;
            LOG.debug((Object)("Removing object with id " + key + " from store after " + age + " ms"));
            this.datas.remove(key);
        }
    }

    private final class Entry {
        final long time = System.currentTimeMillis();
        final Object data;

        private Entry(Object data) {
            this.data = data;
        }
    }
}

