/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.client;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.nmr.flow.jms.JMSFlow;

public class RemoteServiceMixClient
extends DefaultServiceMixClient {
    private JBIContainer container;
    private ActivationSpec activationSpec;
    private String uri;
    private JMSFlow jmsFlow;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);

    public RemoteServiceMixClient() {
        this("peer://org.apache.servicemix?persistent=false");
    }

    public RemoteServiceMixClient(String uri) {
        this(uri, new ActivationSpec());
    }

    public RemoteServiceMixClient(String uri, ActivationSpec activationSpec) {
        this.container = new JBIContainer();
        this.container.setEmbedded(true);
        this.container.setUseMBeanServer(false);
        this.container.setName(new IdGenerator().generateSanitizedId());
        this.uri = uri;
        this.activationSpec = activationSpec;
    }

    public void init() throws JBIException {
        if (this.initialized.compareAndSet(false, true)) {
            this.jmsFlow = new JMSFlow();
            this.jmsFlow.setJmsURL(this.uri);
            this.container.setFlow(this.jmsFlow);
            this.container.setEmbedded(true);
            this.container.setUseMBeanServer(false);
            this.container.setCreateMBeanServer(false);
            this.container.setMonitorDeploymentDirectory(false);
            this.container.setMonitorInstallationDirectory(false);
            this.container.init();
            this.activationSpec.setComponent(this);
            this.container.activateComponent(this.activationSpec);
        }
    }

    public void start() throws JBIException {
        this.start(Long.MAX_VALUE);
    }

    public void start(long timeout) throws JBIException {
        this.init();
        if (this.started.compareAndSet(false, true)) {
            this.container.start();
            if (timeout > 0L) {
                long start = System.currentTimeMillis();
                while (this.jmsFlow.numberInNetwork() == 0 && System.currentTimeMillis() - start < timeout) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new JBIException((Throwable)e);
                    }
                }
                if (this.jmsFlow.numberInNetwork() == 0) {
                    throw new JBIException("Timeout while connecting to remote JBI container");
                }
            }
            super.start();
        }
    }

    public void stop() throws JBIException {
        super.stop();
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.container.shutDown();
    }

    public String getContainerName() {
        return this.container.getName();
    }

    public void setContainerName(String name) {
        this.container.setName(name);
    }

    public void close() throws JBIException {
        this.shutDown();
    }
}

