/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.components.util.MarshalerSupport;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.NoMessageContentAvailableException;

public class DefaultFileMarshaler
extends MarshalerSupport
implements FileMarshaler {
    public static final String FILE_NAME_PROPERTY = "org.apache.servicemix.file.name";
    public static final String FILE_PATH_PROPERTY = "org.apache.servicemix.file.path";
    public static final String FILE_CONTENT = "org.apache.servicemix.file.content";
    protected static final PropertyExpression FILE_NAME_EXPRESSION = new PropertyExpression("org.apache.servicemix.file.name");
    protected static final PropertyExpression FILE_CONTENT_EXPRESSION = new PropertyExpression("org.apache.servicemix.file.content");
    private Expression fileName = FILE_NAME_EXPRESSION;
    private Expression content = FILE_CONTENT_EXPRESSION;
    private String encoding;

    public void readMessage(MessageExchange exchange, NormalizedMessage message, InputStream in, String path) throws IOException, JBIException {
        if (this.encoding == null) {
            message.setContent((Source)new StreamSource(in, path));
        } else {
            message.setContent((Source)new StreamSource(new InputStreamReader(in, Charset.forName(this.encoding)), path));
        }
        message.setProperty(FILE_NAME_PROPERTY, (Object)new File(path).getName());
        message.setProperty(FILE_PATH_PROPERTY, (Object)path);
    }

    public String getOutputName(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        return this.asString(this.fileName.evaluate(exchange, message));
    }

    public void writeMessage(MessageExchange exchange, NormalizedMessage message, OutputStream out, String path) throws IOException, JBIException {
        try {
            Object value = this.content.evaluate(exchange, message);
            if (value != null) {
                this.writeValue(value, out);
            } else {
                this.writeMessageContent(exchange, message, out, path);
            }
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public Expression getContent() {
        return this.content;
    }

    public void setContent(Expression content) {
        this.content = content;
    }

    public Expression getFileName() {
        return this.fileName;
    }

    public void setFileName(Expression fileName) {
        this.fileName = fileName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void writeValue(Object value, OutputStream out) throws IOException, MessagingException {
        if (value instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write((String)value);
            writer.flush();
        } else if (value instanceof byte[]) {
            out.write((byte[])value);
        } else {
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(value);
        }
    }

    protected void writeMessageContent(MessageExchange exchange, NormalizedMessage message, OutputStream out, String path) throws MessagingException {
        Source src = message.getContent();
        if (src == null) {
            throw new NoMessageContentAvailableException(exchange);
        }
        try {
            this.getTransformer().toResult(src, new StreamResult(out), this.encoding);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

