/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import org.apache.commons.lang.StringUtils;
import org.apache.servicemix.components.util.ContentConverter;

public class NumberConverter
implements ContentConverter {
    private boolean zeroValueIsNull = true;
    private boolean blankValueIsNull = true;

    public String convertToXml(String contents) {
        if (contents != null) {
            int number = 0;
            if (StringUtils.isNotBlank((String)contents)) {
                try {
                    number = Integer.parseInt(contents);
                }
                catch (NumberFormatException e) {
                    return contents;
                }
            } else {
                if (this.blankValueIsNull) {
                    return "";
                }
                return contents;
            }
            if (this.zeroValueIsNull && number == 0) {
                return "";
            }
            return String.valueOf(number);
        }
        return null;
    }

    public String convertToFlatFileContent(String contents) {
        return contents;
    }

    public final void setZeroValueIsNull(boolean zeroValueIsNull) {
        this.zeroValueIsNull = zeroValueIsNull;
    }

    public final void setBlankValueIsNull(boolean blankValueIsNull) {
        this.blankValueIsNull = blankValueIsNull;
    }
}

