/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.varscheduler;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.servicemix.components.varscheduler.ScheduleIterator;
import org.apache.servicemix.components.varscheduler.SchedulerTask;

public class Scheduler {
    private Timer timer;

    public Scheduler() {
        this.timer = new Timer();
    }

    public Scheduler(boolean daemon) {
        this.timer = new Timer(daemon);
    }

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerTask task, ScheduleIterator iterator) {
        Date time = iterator.nextExecution();
        if (time == null) {
            task.cancel();
        } else {
            Object object = task.lock;
            synchronized (object) {
                if (task.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                task.state = 1;
                task.timerTask = new SchedulerTimerTask(task, iterator);
                this.timer.schedule(task.timerTask, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SchedulerTask task, ScheduleIterator iterator) {
        Date time = iterator.nextExecution();
        if (time == null) {
            task.cancel();
        } else {
            Object object = task.lock;
            synchronized (object) {
                if (task.state != 2) {
                    task.timerTask = new SchedulerTimerTask(task, iterator);
                    this.timer.schedule(task.timerTask, time);
                }
            }
        }
    }

    class SchedulerTimerTask
    extends TimerTask {
        private SchedulerTask task;
        private ScheduleIterator iterator;

        public SchedulerTimerTask(SchedulerTask task, ScheduleIterator iterator) {
            this.task = task;
            this.iterator = iterator;
        }

        public void run() {
            this.task.run();
            Scheduler.this.reschedule(this.task, this.iterator);
        }
    }
}

