/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry {
    private Map<ComponentNameSpace, ComponentMBeanImpl> idMap = new LinkedHashMap<ComponentNameSpace, ComponentMBeanImpl>();
    private boolean runningStateInitialized;
    private Registry registry;

    protected ComponentRegistry(Registry reg) {
        this.registry = reg;
    }

    public synchronized ComponentMBeanImpl registerComponent(ComponentNameSpace name, String description, Component component, boolean binding, boolean service, String[] sharedLibraries) {
        ComponentMBeanImpl result = null;
        if (!this.idMap.containsKey(name)) {
            result = new ComponentMBeanImpl(this.registry.getContainer(), name, description, component, binding, service, sharedLibraries);
            this.idMap.put(name, result);
        }
        return result;
    }

    public synchronized void start() throws JBIException {
        if (!this.setInitialRunningStateFromStart()) {
            for (ComponentMBeanImpl lcc : this.getComponents()) {
                lcc.doStart();
            }
        }
    }

    public synchronized void stop() throws JBIException {
        for (ComponentMBeanImpl lcc : this.getReverseComponents()) {
            lcc.doStop();
        }
        this.runningStateInitialized = false;
    }

    public synchronized void shutDown() throws JBIException {
        for (ComponentMBeanImpl lcc : this.getReverseComponents()) {
            lcc.persistRunningState();
            lcc.doShutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ComponentMBeanImpl> getReverseComponents() {
        Map<ComponentNameSpace, ComponentMBeanImpl> map = this.idMap;
        synchronized (map) {
            ArrayList<ComponentMBeanImpl> l = new ArrayList<ComponentMBeanImpl>(this.idMap.values());
            Collections.reverse(l);
            return l;
        }
    }

    public synchronized void deregisterComponent(ComponentMBeanImpl component) {
        this.idMap.remove(component.getComponentNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentMBeanImpl getComponent(ComponentNameSpace id) {
        Map<ComponentNameSpace, ComponentMBeanImpl> map = this.idMap;
        synchronized (map) {
            return this.idMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ComponentMBeanImpl> getComponents() {
        Map<ComponentNameSpace, ComponentMBeanImpl> map = this.idMap;
        synchronized (map) {
            return new ArrayList<ComponentMBeanImpl>(this.idMap.values());
        }
    }

    private boolean setInitialRunningStateFromStart() throws JBIException {
        boolean result;
        boolean bl = result = !this.runningStateInitialized;
        if (!this.runningStateInitialized) {
            this.runningStateInitialized = true;
            for (ComponentMBeanImpl lcc : this.getComponents()) {
                if (!lcc.isPojo() && !this.registry.isContainerEmbedded()) {
                    lcc.setInitialRunningState();
                    continue;
                }
                lcc.doStart();
            }
        }
        return result;
    }
}

