/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicemix.jbi.container.SubscriptionSpec;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionRegistry {
    private Map<SubscriptionSpec, InternalEndpoint> subscriptions = new ConcurrentHashMap<SubscriptionSpec, InternalEndpoint>();
    private Registry registry;

    public SubscriptionRegistry(Registry registry) {
        this.registry = registry;
    }

    public void registerSubscription(SubscriptionSpec subscription, InternalEndpoint endpoint) {
        this.subscriptions.put(subscription, endpoint);
    }

    public InternalEndpoint deregisterSubscription(SubscriptionSpec subscription) {
        return this.subscriptions.remove(subscription);
    }

    public List<InternalEndpoint> getMatchingSubscriptionEndpoints(MessageExchangeImpl exchange) {
        ArrayList<InternalEndpoint> result = null;
        for (Map.Entry<SubscriptionSpec, InternalEndpoint> entry : this.subscriptions.entrySet()) {
            SubscriptionSpec subscription = entry.getKey();
            if (!subscription.matches(this.registry, exchange)) continue;
            if (result == null) {
                result = new ArrayList<InternalEndpoint>();
            }
            InternalEndpoint endpoint = entry.getValue();
            result.add(endpoint);
        }
        return result;
    }
}

