/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework.support;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.support.EndpointProcessor;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.woden.WSDLSource;
import org.apache.woden.internal.DOMWSDLReader;
import org.apache.woden.internal.DOMWSDLSource;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.w3c.dom.Document;

public class WSDL2Processor
implements EndpointProcessor {
    public static final String WSDL2_NAMESPACE = "http://www.w3.org/2006/01/wsdl";
    private static final Log LOG = LogFactory.getLog(WSDL2Processor.class);
    private Registry registry;

    public void init(Registry reg) {
        this.registry = reg;
    }

    public void process(InternalEndpoint serviceEndpoint) {
        block14: {
            try {
                Document document = this.registry.getEndpointDescriptor(serviceEndpoint);
                if (document == null || document.getDocumentElement() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " has no service description"));
                    }
                    return;
                }
                if (!WSDL2_NAMESPACE.equals(document.getDocumentElement().getNamespaceURI())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " has a non WSDL2 service description"));
                    }
                    return;
                }
                DOMWSDLReader reader = new DOMWSDLReader();
                DOMWSDLSource source = (DOMWSDLSource)reader.createWSDLSource();
                source.setSource((Object)document);
                DescriptionElement descElement = reader.readWSDL((WSDLSource)source);
                Description desc = descElement.toComponent();
                if (desc.getInterfaces().length == 1 && desc.getServices().length == 0) {
                    Interface itf = desc.getInterfaces()[0];
                    QName interfaceName = itf.getName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                } else {
                    Service service = desc.getService(serviceEndpoint.getServiceName());
                    if (service == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching service found in " + desc.getServices()));
                        return;
                    }
                    Endpoint endpoint = service.getEndpoint(new NCName(serviceEndpoint.getEndpointName()));
                    if (endpoint == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching endpoint found in " + service.getEndpoints()));
                        return;
                    }
                    if (endpoint.getBinding() == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no binding found"));
                        return;
                    }
                    if (endpoint.getBinding().getInterface() == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no port type found"));
                        return;
                    }
                    QName interfaceName = endpoint.getBinding().getInterface().getName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error retrieving interfaces from service description: " + e.getMessage()));
                if (!LOG.isDebugEnabled()) break block14;
                LOG.debug((Object)"Error retrieving interfaces from service description", (Throwable)e);
            }
        }
    }
}

