/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jmx;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;

public class ConnectorServerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private static final Constants CONSTANTS = new Constants(ConnectorServerFactoryBean.class);
    private Log log = LogFactory.getLog(ConnectorServerFactoryBean.class);
    private org.springframework.jmx.support.ConnectorServerFactoryBean csfb = new org.springframework.jmx.support.ConnectorServerFactoryBean();
    private String serviceUrl = "service:jmx:jmxmp://localhost:9875";
    private boolean daemon;
    private boolean threaded;
    private Map environment;
    private Object objectName;
    private int registrationBehavior = 0;
    private MBeanServer server;

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public void setObjectName(String objectName) throws MalformedObjectNameException {
        this.objectName = objectName;
    }

    public void setRegistrationBehavior(int registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }

    public void setRegistrationBehaviorName(String behavior) {
        this.setRegistrationBehavior(CONSTANTS.asNumber(behavior).intValue());
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setThreaded(boolean threaded) {
        this.csfb.setThreaded(threaded);
    }

    public Object getObject() throws Exception {
        return this.csfb.getObject();
    }

    public Class getObjectType() {
        return this.csfb.getObjectType();
    }

    public boolean isSingleton() {
        return this.csfb.isSingleton();
    }

    public void afterPropertiesSet() throws Exception {
        this.csfb = new org.springframework.jmx.support.ConnectorServerFactoryBean();
        this.csfb.setDaemon(this.daemon);
        this.csfb.setThreaded(this.threaded);
        this.csfb.setRegistrationBehavior(this.registrationBehavior);
        this.csfb.setEnvironmentMap(this.environment);
        this.csfb.setObjectName(this.objectName);
        this.serviceUrl = this.serviceUrl.replaceAll(" ", "");
        this.csfb.setServiceUrl(this.serviceUrl);
        this.csfb.setServer(this.server);
        this.csfb.afterPropertiesSet();
        this.log.info((Object)("JMX connector available at: " + this.serviceUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.csfb != null) {
            try {
                this.csfb.destroy();
            }
            finally {
                this.csfb = null;
            }
        }
    }
}

