/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.monitoring;

import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.monitoring.EndpointStatsMBean;
import org.apache.servicemix.jbi.monitoring.MessagingStats;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;

public class EndpointStats
extends BaseLifeCycle
implements EndpointStatsMBean {
    private AbstractServiceEndpoint endpoint;
    private MessagingStats stats;

    public EndpointStats(AbstractServiceEndpoint endpoint, MessagingStats componentStats) {
        this.endpoint = endpoint;
        this.stats = new MessagingStats(EndpointSupport.getUniqueKey(endpoint), componentStats);
    }

    MessagingStats getMessagingStats() {
        return this.stats;
    }

    void incrementInbound() {
        this.stats.getInboundExchanges().increment();
        this.stats.getInboundExchangeRate().addTime();
    }

    void incrementOutbound() {
        this.stats.getOutboundExchanges().increment();
        this.stats.getOutboundExchangeRate().addTime();
    }

    public String getType() {
        return "Statistics";
    }

    public String getSubType() {
        return "Endpoint";
    }

    public String getName() {
        return EndpointSupport.getUniqueKey(this.endpoint);
    }

    public String getDescription() {
        return "Statistics for endpoint " + EndpointSupport.getUniqueKey(this.endpoint);
    }

    public long getInboundExchangeCount() {
        return this.stats.getInboundExchanges().getCount();
    }

    public double getInboundExchangeRate() {
        return this.stats.getInboundExchangeRate().getAveragePerSecond();
    }

    public long getOutboundExchangeCount() {
        return this.stats.getOutboundExchanges().getCount();
    }

    public double getOutboundExchangeRate() {
        return this.stats.getOutboundExchangeRate().getAveragePerSecond();
    }

    public void reset() {
        this.stats.reset();
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeCount", "count of inbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeCount", "count of outbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeRate", "rate of inbound exchanges/sec");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeRate", "rate of outbound exchanges/sec");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "reset", "reset statistic counters");
        return helper.getOperationInfos();
    }
}

