/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security;

import java.security.Principal;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.DefaultBroker;
import org.apache.servicemix.jbi.security.GroupPrincipal;
import org.apache.servicemix.jbi.security.acl.AuthorizationMap;

public class SecuredBroker
extends DefaultBroker {
    private static final Log LOG = LogFactory.getLog(SecuredBroker.class);
    private AuthorizationMap authorizationMap;

    public SecuredBroker() {
    }

    public SecuredBroker(AuthorizationMap authorizationMap) {
        this.authorizationMap = authorizationMap;
    }

    public AuthorizationMap getAuthorizationMap() {
        return this.authorizationMap;
    }

    public void setAuthorizationMap(AuthorizationMap authorizationMap) {
        this.authorizationMap = authorizationMap;
    }

    public void sendExchangePacket(MessageExchange me) throws JBIException {
        LOG.debug((Object)"send exchange with secure broker");
        MessageExchangeImpl exchange = (MessageExchangeImpl)me;
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getDestinationId() == null) {
            this.resolveAddress(exchange);
            ServiceEndpoint se = exchange.getEndpoint();
            if (se != null) {
                LOG.debug((Object)("service name :" + se.getServiceName()));
                LOG.debug((Object)("operation name :" + me.getOperation()));
                Set<Principal> acls = this.authorizationMap.getAcls(se, me.getOperation());
                if (!acls.contains(GroupPrincipal.ANY)) {
                    Subject subject = exchange.getMessage("in").getSecuritySubject();
                    if (subject == null) {
                        throw new SecurityException("User not authenticated");
                    }
                    LOG.debug((Object)("authorization for " + subject));
                    acls.retainAll(subject.getPrincipals());
                    if (acls.size() == 0) {
                        throw new SecurityException("Endpoint is not authorized for this user");
                    }
                }
            }
        }
        super.sendExchangePacket(me);
    }
}

