/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.view.DotViewEndpointListener;
import org.apache.servicemix.jbi.view.DotViewFlowListener;
import org.apache.servicemix.jbi.view.DotViewServiceMBean;
import org.springframework.beans.factory.InitializingBean;

public class DotViewService
extends BaseSystemService
implements InitializingBean,
DotViewServiceMBean {
    private JBIContainer container;
    private boolean autoStart = true;
    private DotViewEndpointListener endpointListener;
    private DotViewFlowListener flowListener;

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    protected Class getServiceMBean() {
        return DotViewServiceMBean.class;
    }

    public String getDescription() {
        return "DotView service";
    }

    public void start() throws JBIException {
        super.start();
        this.container.addListener(this.endpointListener);
        this.container.addListener(this.flowListener);
    }

    public void stop() throws JBIException {
        this.container.removeListener(this.endpointListener);
        this.container.removeListener(this.flowListener);
        super.stop();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.container == null) {
            throw new IllegalArgumentException("container should not be null");
        }
        this.init(this.getContainer());
        this.endpointListener = new DotViewEndpointListener();
        this.endpointListener.setContainer(this.container);
        this.endpointListener.setRerenderOnChange(false);
        this.flowListener = new DotViewFlowListener();
        this.flowListener.setContainer(this.container);
        this.flowListener.setRerenderOnChange(false);
        if (this.autoStart) {
            this.start();
        } else {
            this.stop();
        }
    }

    public String createEndpointGraph() throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.endpointListener.generateFile(pw);
        return sw.toString();
    }

    public String createFlowGraph() throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.flowListener.generateFile(pw);
        return sw.toString();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "createEndpointGraph", 0, "create an endpoint dot graph");
        helper.addOperation(this.getObjectToManage(), "createFlowGraph", 0, "create an flow dot graph");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }
}

