/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.sql.DataSource;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Node;

public class JdbcComponent
extends TransformComponentSupport
implements MessageExchangeListener {
    private static final Log log = LogFactory.getLog(JdbcComponent.class);
    private DataSource dataSource;
    private boolean responseRequired = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        log.debug((Object)("Received a JDBC request. Datasource=" + this.dataSource + ", ResponseRequired=" + this.responseRequired));
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            boolean bl;
            SourceTransformer domTransform = new SourceTransformer();
            Node domNode = domTransform.toDOMNode(in);
            String query = this.getQuery(domNode);
            log.debug((Object)("Retrieved query: " + query));
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            Source outMsg = null;
            if (query != null && query.length() > 0) {
                if (stmt.execute(query)) {
                    rs = stmt.getResultSet();
                    log.debug((Object)("Formatting ResultSet: " + rs));
                    outMsg = this.toXmlSource(rs);
                } else {
                    int updateCount = stmt.getUpdateCount();
                    if (updateCount > -1) {
                        log.debug((Object)("Formatting UpdateCount: " + updateCount));
                        outMsg = this.toXmlSource(updateCount);
                    } else {
                        log.debug((Object)"Formatting NoResult.");
                        outMsg = null;
                    }
                }
            }
            if (outMsg != null) {
                log.debug((Object)("Response: " + domTransform.toString(outMsg)));
                out.setContent(outMsg);
                bl = true;
                return bl;
            }
            if (this.responseRequired) {
                log.debug((Object)"Response: Empty Response");
                out.setContent(this.toXmlSource());
                bl = true;
                return bl;
            }
            log.debug((Object)"Response: No Response");
            bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"JDBC Component Exception: ", (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public String getQuery(Node node) throws Exception {
        CachedXPathAPI xpath = new CachedXPathAPI();
        if ((node = xpath.selectSingleNode(node, "sql/child::text()")) == null) {
            throw new IllegalStateException("Expecting <sql></sql> node. Found: " + node);
        }
        return node.getNodeValue();
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setResponseRequired(boolean val) {
        this.responseRequired = val;
    }

    public boolean getResponseRequired() {
        return this.responseRequired;
    }

    protected Source toXmlSource(ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        String[] colNames = this.getUniqueColumnNames(meta);
        StringBuffer buff = new StringBuffer("");
        while (rs.next()) {
            buff.append("<row ");
            for (int i = 0; i < colCount; ++i) {
                buff.append(colNames[i].toLowerCase() + "='" + rs.getString(i + 1) + "' ");
            }
            buff.append("/>");
        }
        if (buff.length() <= 0) {
            return null;
        }
        buff.insert(0, "<sqlResult><resultSet>");
        buff.append("</resultSet></sqlResult>");
        return new StringSource(buff.toString());
    }

    protected String[] getUniqueColumnNames(ResultSetMetaData metaData) throws SQLException {
        LinkedList<String> colNames = new LinkedList<String>();
        HashMap<String, Integer> chanedNames = new HashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String name = metaData.getColumnName(i);
            if (name.equals("")) {
                name = "__unknown_column__";
            }
            if (colNames.contains(name)) {
                int count;
                if (chanedNames.containsKey(name)) {
                    Integer integer = (Integer)chanedNames.get(name);
                    Integer newInteger = new Integer(integer + 1);
                    chanedNames.put(name, newInteger);
                    count = newInteger;
                } else {
                    chanedNames.put(name, new Integer(1));
                    count = 1;
                }
                name = name + "_" + count;
            }
            colNames.add(name);
        }
        return colNames.toArray(new String[colNames.size()]);
    }

    protected Source toXmlSource(int updateCount) throws Exception {
        return new StringSource("<sqlResult><updateCount value='" + updateCount + "'/></sqlResult>");
    }

    protected Source toXmlSource() throws Exception {
        return new StringSource("<sqlResult></sqlResult>");
    }
}

