/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.jms.JmsMarshaler;
import org.apache.servicemix.components.util.OutBinding;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JmsSenderComponent
extends OutBinding {
    private static final Log log = LogFactory.getLog(JmsSenderComponent.class);
    private JmsTemplate template;
    private JmsMarshaler marshaler = new JmsMarshaler();

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public JmsMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public boolean isNeedJavaIdentifiers() {
        return this.marshaler.isNeedJavaIdentifiers();
    }

    public void setNeedJavaIdentifiers(boolean needJavaIdentifiers) {
        this.marshaler.setNeedJavaIdentifiers(needJavaIdentifiers);
    }

    protected void process(MessageExchange exchange, final NormalizedMessage inMessage) throws Exception {
        this.template.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                try {
                    Message message = JmsSenderComponent.this.marshaler.createMessage(inMessage, session);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Sending message to: " + JmsSenderComponent.this.template.getDefaultDestinationName() + " message: " + message));
                    }
                    return message;
                }
                catch (TransformerException e) {
                    JMSException jmsEx = new JMSException("Failed to create JMS Message: " + e);
                    jmsEx.setLinkedException((Exception)e);
                    throw jmsEx;
                }
            }
        });
        this.done(exchange);
    }
}

