/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jmx;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.jaxp.StringSource;

public class CounterMonitorComponent
extends ComponentSupport
implements NotificationListener,
MessageExchangeListener {
    private static final Log log = LogFactory.getLog(ComponentSupport.class);
    private String name;
    private ObjectName ourName;
    private String observedObjectName;
    private String attributeName;
    private long granularityPeriod = 5000L;
    private Number threshold;
    private Number offset;
    private MBeanServer mbeanServer;
    private CounterMonitor counterMonitor = new CounterMonitor();

    public void init(ComponentContext cc) throws JBIException {
        super.init(cc);
        this.validate();
        if (this.mbeanServer == null) {
            this.mbeanServer = cc.getMBeanServer();
        }
        try {
            ObjectName observedName = new ObjectName(this.observedObjectName);
            if (this.name == null) {
                String type = observedName.getKeyProperty("type");
                type = type != null ? type : "UNKNOWN";
                this.name = this.mbeanServer.getDefaultDomain() + ":type=CounterMonitor_" + type;
            }
            this.ourName = new ObjectName(this.name);
            this.counterMonitor.setNotify(true);
            this.counterMonitor.addObservedObject(observedName);
            this.counterMonitor.setObservedAttribute(this.attributeName);
            this.counterMonitor.setGranularityPeriod(this.granularityPeriod);
            this.counterMonitor.setDifferenceMode(false);
            this.counterMonitor.setInitThreshold(this.threshold);
            this.counterMonitor.setOffset(this.offset);
            this.mbeanServer.registerMBean(this.counterMonitor, this.ourName);
            this.mbeanServer.addNotificationListener(this.ourName, this, null, new Object());
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void start() throws JBIException {
        super.start();
        this.counterMonitor.start();
    }

    public void stop() throws JBIException {
        this.counterMonitor.stop();
        super.stop();
    }

    public void shutDown() throws JBIException {
        this.stop();
        if (this.ourName != null && this.mbeanServer != null) {
            try {
                this.mbeanServer.removeNotificationListener(this.ourName, this);
            }
            catch (Exception e) {
                throw new JBIException((Throwable)e);
            }
        }
        super.shutDown();
    }

    public void handleNotification(Notification notification, Object arg1) {
        try {
            StringSource source = new StringSource(notification.getMessage());
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            message.setContent((Source)source);
            exchange.setInMessage(message);
            this.send((MessageExchange)exchange);
        }
        catch (Exception e) {
            log.error((Object)"Failed to send Notification message to the NMR");
        }
    }

    protected void validate() throws JBIException {
        if (this.observedObjectName == null) {
            throw new DeploymentException("observedObjectName is null");
        }
        if (this.attributeName == null) {
            throw new DeploymentException("attributeName is null");
        }
        if (this.threshold == null) {
            throw new DeploymentException("threshold is null");
        }
        if (this.offset == null) {
            throw new DeploymentException("offset is null");
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public CounterMonitor getCounterMonitor() {
        return this.counterMonitor;
    }

    public void setCounterMonitor(CounterMonitor counterMonitor) {
        this.counterMonitor = counterMonitor;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long granularityPeriod) {
        this.granularityPeriod = granularityPeriod;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObservedObjectName() {
        return this.observedObjectName;
    }

    public void setObservedObjectName(String observedObjectName) {
        this.observedObjectName = observedObjectName;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number offset) {
        this.offset = offset;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Number threshold) {
        this.threshold = threshold;
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
    }
}

