/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.mps;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.mps.ConfigNotSupportedException;
import org.apache.servicemix.components.mps.PropertySet;
import org.apache.servicemix.components.mps.PropertySetNotFoundException;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MessagePropertySetterXML
extends TransformComponentSupport {
    private final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String MPS_PROP_NAME_PROPERTYSET = "org.apache.servicemix.components.mps.propertyset";
    public static final String XML_ELEMENT_NAME = "property-set";
    private Resource xmlConfiguration = null;
    private Document xmlMPSdom = null;
    private Map propertSets = new HashMap();
    private String propertySet = null;
    private String xpathForPropertySet = null;

    protected boolean transform(MessageExchange arg0, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        try {
            this.copyPropertiesAndAttachments(arg0, in, out);
            out.setContent(in.getContent());
            String propertySetName = "";
            if (this.xpathForPropertySet != null) {
                try {
                    CachedXPathAPI xpathApi = new CachedXPathAPI();
                    Document doc = new SourceTransformer().toDOMDocument(in);
                    XObject propSetXO = xpathApi.eval((Node)doc.getDocumentElement(), this.xpathForPropertySet);
                    propertySetName = propSetXO.str();
                }
                catch (Exception e) {
                    throw new MessagingException("Problem getting the propertySet using XPath", (Throwable)e);
                }
            } else if (this.propertySet != null) {
                propertySetName = this.propertySet;
            } else if (in.getProperty(MPS_PROP_NAME_PROPERTYSET) != null) {
                propertySetName = in.getProperty(MPS_PROP_NAME_PROPERTYSET).toString();
            } else {
                return false;
            }
            this.logger.info((Object)("Applying properties from property-set [" + propertySetName + "]"));
            this.getPropertySetByName(propertySetName).applyProperties(in, out);
            return true;
        }
        catch (JBIException e) {
            throw new MessagingException("Problem setting properties", (Throwable)e);
        }
        catch (PropertySetNotFoundException e) {
            this.logger.warn((Object)e.getLocalizedMessage());
            return false;
        }
    }

    private void initConfig() throws JBIException {
        Assert.notNull((Object)this.xmlConfiguration);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringElementContentWhitespace(true);
        domFactory.setIgnoringComments(true);
        domFactory.setCoalescing(true);
        try {
            this.logger.info((Object)("Intialising MessagePropertySetterXML, loading settings from " + this.xmlConfiguration.getFile().getAbsolutePath()));
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            this.xmlMPSdom = domBuilder.parse(this.xmlConfiguration.getInputStream());
        }
        catch (ParserConfigurationException e) {
            throw new JBIException("Problem parsing the XML config file for MPS", (Throwable)e);
        }
        catch (SAXException e) {
            throw new JBIException("Problem loading the XML config file for MPS", (Throwable)e);
        }
        catch (IOException e) {
            throw new JBIException("Problem loading the XML config file for MPS", (Throwable)e);
        }
    }

    public void init(ComponentContext context) throws JBIException {
        super.init(context);
        this.initConfig();
    }

    private PropertySet createPropertySet(String propertySetName) throws JBIException, PropertySetNotFoundException {
        PropertySet ps;
        CachedXPathAPI xpath = new CachedXPathAPI();
        StringBuffer xpathSB = new StringBuffer("//").append(XML_ELEMENT_NAME).append("[@name='").append(propertySetName).append("']");
        try {
            Node propertySetNode = xpath.selectSingleNode((Node)this.xmlMPSdom, xpathSB.toString());
            if (propertySetNode == null) {
                throw new PropertySetNotFoundException("Could not find a property-set for [" + propertySetName + "] in " + this.xmlConfiguration.getFilename());
            }
            ps = new PropertySet(propertySetName, (Element)propertySetNode);
            this.propertSets.put(propertySetName, ps);
        }
        catch (TransformerException e) {
            throw new JBIException("Could not load the PropertySet for " + this.propertySet, (Throwable)e);
        }
        catch (ConfigNotSupportedException e) {
            throw new JBIException("Could not load the PropertySet for. XMLConfig is not good for " + this.propertySet, (Throwable)e);
        }
        return ps;
    }

    private PropertySet getPropertySetByName(String name) throws JBIException, PropertySetNotFoundException {
        if (this.propertSets.containsKey(name)) {
            return (PropertySet)this.propertSets.get(name);
        }
        return this.createPropertySet(name);
    }

    public void setPropertySet(String propertySet) {
        this.propertySet = propertySet;
    }

    public void setXmlConfiguration(Resource xmlConfiguration) {
        this.xmlConfiguration = xmlConfiguration;
    }

    public void setXpathForPropertySet(String xpathForPropertySet) {
        this.xpathForPropertySet = xpathForPropertySet;
    }
}

