/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.wsif;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.components.wsif.FailedToCreateDOMException;
import org.apache.servicemix.components.wsif.WSIFOperationInfo;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.jbi.util.LazyDOMSource;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSIFMarshaler {
    public static final String WSDL_WRAPPER_NAMESPACE = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    private SourceTransformer transformer = new SourceTransformer();

    public void toNMS(final MessageExchange exchange, final NormalizedMessage nmsMessage, final WSIFOperationInfo operationInfo, final WSIFMessage wsifMessage) throws WSIFException, MessagingException {
        this.addNmsProperties(nmsMessage, wsifMessage);
        Iterator iter = wsifMessage.getPartNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = wsifMessage.getObjectPart(name);
            nmsMessage.setProperty(name, value);
        }
        nmsMessage.setContent((Source)new LazyDOMSource(){

            protected Node loadNode() {
                return WSIFMarshaler.this.createResultDocument(exchange, nmsMessage, operationInfo, wsifMessage);
            }
        });
    }

    public void fromNMS(WSIFOperationInfo operationInfo, WSIFMessage wsifMessage, NormalizedMessage nmsMessage, Object body) throws WSIFException, MessagingException {
        this.addWSIFProperties(wsifMessage, nmsMessage);
        try {
            Element element = this.transformer.toDOMElement(nmsMessage);
            Map parts = wsifMessage.getMessageDefinition().getParts();
            for (Map.Entry entry : parts.entrySet()) {
                String name = (String)entry.getKey();
                Part part = (Part)entry.getValue();
                Object value = this.getPartValue(name, part, nmsMessage, element);
                wsifMessage.setObjectPart(name, value);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public SourceTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(SourceTransformer transformer) {
        this.transformer = transformer;
    }

    protected void addNmsProperties(NormalizedMessage nmsMessage, WSIFMessage wsifMessage) throws WSIFException {
        Iterator iter = wsifMessage.getPartNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = wsifMessage.getObjectPart(name);
            nmsMessage.setProperty(name, value);
        }
    }

    protected void addWSIFProperties(WSIFMessage wsifMessage, NormalizedMessage nmsMessage) throws WSIFException {
        for (String name : nmsMessage.getPropertyNames()) {
            Object value;
            if (!this.shouldIncludeHeader(nmsMessage, name, value = nmsMessage.getProperty(name))) continue;
            wsifMessage.setObjectPart(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return true;
    }

    protected Object getPartValue(String name, Part part, NormalizedMessage nmsMessage, Element body) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        if (this.isSimpleType(part)) {
            return DOMUtil.getElementText((Element)body).trim();
        }
        return this.transformer.toDOMNode(nmsMessage);
    }

    protected boolean isSimpleType(Part part) {
        QName typeName = part.getTypeName();
        if (typeName != null) {
            return "http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI());
        }
        return false;
    }

    protected Node createResultDocument(MessageExchange exchange, NormalizedMessage normalizedMessage, WSIFOperationInfo operationInfo, WSIFMessage wsifMessage) {
        try {
            Document document = this.transformer.createDocument();
            Element root = document.createElementNS(WSDL_WRAPPER_NAMESPACE, "jbi:message");
            document.appendChild(root);
            root.setAttribute("xmlns:jbi", WSDL_WRAPPER_NAMESPACE);
            QName operation = exchange.getOperation();
            String operationName = "unknown";
            if (operation != null) {
                operationName = operation.getLocalPart();
                String uri = operation.getNamespaceURI();
                if (uri != null && uri.length() > 0) {
                    root.setAttribute("xmlns:op", uri);
                }
            }
            root.setAttribute("version", "1.0");
            root.setAttribute("type", "op:" + operationName);
            root.setAttribute("name", operationName);
            Iterator iter = wsifMessage.getPartNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = normalizedMessage.getProperty(name);
                Element element = document.createElementNS(WSDL_WRAPPER_NAMESPACE, "jbi:part");
                root.appendChild(element);
                this.addPartValue(element, name, value);
            }
            return document;
        }
        catch (Exception e) {
            throw new FailedToCreateDOMException(e);
        }
    }

    protected void addPartValue(Element element, String name, Object value) {
        if (value instanceof Document) {
            Document doc = (Document)value;
            Element root = doc.getDocumentElement();
            doc.removeChild(root);
            element.appendChild(root);
        } else if (value != null) {
            String text = value.toString();
            element.appendChild(element.getOwnerDocument().createTextNode(text));
        }
    }
}

