/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit;

import java.util.EventListener;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;

public abstract class AbstractAuditor
extends BaseSystemService
implements AuditorMBean,
ExchangeListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean asContainerListener = true;

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    protected Class getServiceMBean() {
        return AuditorMBean.class;
    }

    public void start() throws JBIException {
        super.start();
        this.doStart();
        if (this.isAsContainerListener()) {
            this.container.addListener((EventListener)((Object)this));
        }
    }

    public void stop() throws JBIException {
        this.container.removeListener((EventListener)((Object)this));
        this.doStop();
        super.stop();
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "exchangeCount", "number of exchanges");
        return AttributeInfoHelper.join((MBeanAttributeInfo[])super.getAttributeInfos(), (MBeanAttributeInfo[])helper.getAttributeInfos());
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "getExchangesByRange", 2, "retrieve a bunch messages");
        ph.setDescription(0, "fromIndex", "lower index of message (start from 0)");
        ph.setDescription(1, "toIndex", "upper index of message (exclusive, > fromIndex)");
        ph = helper.addOperation(this.getObjectToManage(), "getExchangeById", 1, "retrieve an exchange given its id");
        ph.setDescription(0, "id", "id of the exchange to retrieve");
        return OperationInfoHelper.join((MBeanOperationInfo[])super.getOperationInfos(), (MBeanOperationInfo[])helper.getOperationInfos());
    }

    public abstract int getExchangeCount() throws AuditorException;

    public String getExchangeIdByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchangeIdsByRange(index, index + 1)[0];
    }

    public String[] getAllExchangeIds() throws AuditorException {
        return this.getExchangeIdsByRange(0, this.getExchangeCount());
    }

    public abstract String[] getExchangeIdsByRange(int var1, int var2) throws AuditorException;

    public MessageExchange getExchangeByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchangesByRange(index, index + 1)[0];
    }

    public MessageExchange getExchangeById(String id) throws AuditorException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id should be non null and non empty");
        }
        return this.getExchangesByIds(new String[]{id})[0];
    }

    public MessageExchange[] getAllExchanges() throws AuditorException {
        return this.getExchangesByRange(0, this.getExchangeCount());
    }

    public MessageExchange[] getExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.getExchangesByIds(this.getExchangeIdsByRange(fromIndex, toIndex));
    }

    public abstract MessageExchange[] getExchangesByIds(String[] var1) throws AuditorException;

    public int deleteAllExchanges() throws AuditorException {
        return this.deleteExchangesByRange(0, this.getExchangeCount());
    }

    public boolean deleteExchangeByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.deleteExchangesByRange(index, index + 1) == 1;
    }

    public boolean deleteExchangeById(String id) throws AuditorException {
        return this.deleteExchangesByIds(new String[]{id}) == 1;
    }

    public int deleteExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.deleteExchangesByIds(this.getExchangeIdsByRange(fromIndex, toIndex));
    }

    public abstract int deleteExchangesByIds(String[] var1) throws AuditorException;

    public void resendExchange(MessageExchange exchange) throws JBIException {
        this.container.resendExchange(exchange);
    }

    public boolean isAsContainerListener() {
        return this.asContainerListener;
    }

    public void setAsContainerListener(boolean addToContainer) {
        this.asContainerListener = addToContainer;
    }

    public void exchangeAccepted(ExchangeEvent event) {
    }
}

