/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionHandleInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.MCFConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SubjectInterceptor;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.TCCLInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;

public class GenericConnectionManager
extends AbstractConnectionManager {
    protected static final Log log = LogFactory.getLog((String)AbstractSinglePoolConnectionInterceptor.class.getName());

    public GenericConnectionManager() {
    }

    public GenericConnectionManager(TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, ConnectionTracker connectionTracker, RecoverableTransactionManager transactionManager, String name, ClassLoader classLoader) {
        super(new InterceptorsImpl(transactionSupport, pooling, subjectSource, name, connectionTracker, (TransactionManager)transactionManager, classLoader), transactionManager);
    }

    private static class InterceptorsImpl
    implements AbstractConnectionManager.Interceptors {
        private final ConnectionInterceptor stack;
        private final ConnectionInterceptor recoveryStack;
        private final PoolingSupport poolingSupport;

        public InterceptorsImpl(TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, String name, ConnectionTracker connectionTracker, TransactionManager transactionManager, ClassLoader classLoader) {
            MCFConnectionInterceptor tail;
            if (subjectSource == null && pooling instanceof PartitionedPool && ((PartitionedPool)pooling).isPartitionBySubject()) {
                throw new IllegalStateException("To use Subject in pooling, you need a SecurityDomain");
            }
            ConnectionInterceptor stack = tail = new MCFConnectionInterceptor();
            stack = transactionSupport.addXAResourceInsertionInterceptor(stack, name);
            stack = pooling.addPoolingInterceptors(stack);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Connection Manager " + name + " installed pool " + stack));
            }
            this.poolingSupport = pooling;
            stack = transactionSupport.addTransactionInterceptors(stack, transactionManager);
            if (subjectSource != null) {
                stack = new SubjectInterceptor(stack, subjectSource);
            }
            this.recoveryStack = transactionSupport.isRecoverable() ? new TCCLInterceptor(stack, classLoader) : null;
            stack = new ConnectionHandleInterceptor(stack);
            stack = new TCCLInterceptor(stack, classLoader);
            if (connectionTracker != null) {
                stack = new ConnectionTrackingInterceptor(stack, name, connectionTracker);
            }
            tail.setStack(stack);
            this.stack = stack;
        }

        public ConnectionInterceptor getStack() {
            return this.stack;
        }

        public ConnectionInterceptor getRecoveryStack() {
            return this.recoveryStack;
        }

        public PoolingSupport getPoolingAttributes() {
            return this.poolingSupport;
        }
    }
}

