/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.util.Set;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.StartStrategy;
import org.apache.xbean.kernel.UnregisterServiceException;
import org.apache.xbean.kernel.UnsatisfiedConditionsException;

public final class StartStrategies {
    public static final StartStrategy SYNCHRONOUS = new Synchronous();
    public static final StartStrategy ASYNCHRONOUS = new Asynchronous();
    public static final StartStrategy BLOCK = new Block();
    public static final StartStrategy UNREGISTER = new Unregister();

    private StartStrategies() {
    }

    private static class Unregister
    implements StartStrategy {
        private Unregister() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) throws UnregisterServiceException {
            UnsatisfiedConditionsException userException = new UnsatisfiedConditionsException("Unsatisfied start conditions", serviceName, conditions);
            throw new UnregisterServiceException(serviceName, (Throwable)userException);
        }

        public void startError(ServiceName serviceName, Throwable startError) throws UnregisterServiceException {
            throw new UnregisterServiceException(serviceName, startError);
        }
    }

    private static class Block
    implements StartStrategy {
        private Block() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) {
            return true;
        }

        public void startError(ServiceName serviceName, Throwable startError) throws Exception {
            if (startError instanceof Exception) {
                throw (Exception)startError;
            }
            if (startError instanceof Error) {
                throw (Error)startError;
            }
            throw new AssertionError((Object)startError);
        }
    }

    private static class Asynchronous
    implements StartStrategy {
        private Asynchronous() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) {
            return false;
        }

        public void startError(ServiceName serviceName, Throwable startError) {
        }
    }

    private static class Synchronous
    implements StartStrategy {
        private Synchronous() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) throws UnsatisfiedConditionsException {
            throw new UnsatisfiedConditionsException("Unsatisfied start conditions", serviceName, conditions);
        }

        public void startError(ServiceName serviceName, Throwable startError) throws Exception {
            if (startError instanceof Exception) {
                throw (Exception)startError;
            }
            if (startError instanceof Error) {
                throw (Error)startError;
            }
            throw new AssertionError((Object)startError);
        }
    }
}

