/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.xbean.kernel.IllegalServiceStateException;
import org.apache.xbean.kernel.KernelErrorsError;
import org.apache.xbean.kernel.KernelOperationInterruptedException;
import org.apache.xbean.kernel.ServiceAlreadyExistsException;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceRegistrationException;
import org.apache.xbean.kernel.StopStrategies;
import org.apache.xbean.kernel.StopStrategy;
import org.apache.xbean.kernel.UnsatisfiedConditionsException;
import org.apache.xbean.kernel.standard.RegistryFutureTask;
import org.apache.xbean.kernel.standard.ServiceManager;
import org.apache.xbean.kernel.standard.ServiceManagerFactory;

public class ServiceManagerRegistry {
    private final AtomicLong serviceId = new AtomicLong(1L);
    private final ServiceManagerFactory serviceManagerFactory;
    private final Map serviceManagers = new HashMap();
    private final Map serviceManagersByType = new HashMap();

    public ServiceManagerRegistry(ServiceManagerFactory serviceManagerFactory) {
        this.serviceManagerFactory = serviceManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws KernelErrorsError {
        ArrayList managerFutures;
        ArrayList<AssertionError> errors = new ArrayList<AssertionError>();
        Map map = this.serviceManagers;
        synchronized (map) {
            managerFutures = new ArrayList(this.serviceManagers.values());
            this.serviceManagers.clear();
        }
        ArrayList managers = new ArrayList(managerFutures.size());
        for (RegistryFutureTask registryFutureTask : managerFutures) {
            try {
                managers.add(registryFutureTask.get());
            }
            catch (InterruptedException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (ExecutionException e) {}
        }
        errors.addAll(this.stopAll(managers, StopStrategies.ASYNCHRONOUS));
        errors.addAll(this.stopAll(managers, StopStrategies.ASYNCHRONOUS));
        errors.addAll(this.stopAll(managers, StopStrategies.FORCE));
        for (ServiceManager serviceManager : managers) {
            try {
                serviceManager.destroy(StopStrategies.FORCE);
            }
            catch (UnsatisfiedConditionsException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (IllegalServiceStateException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (RuntimeException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (Error e) {
                errors.add(new AssertionError((Object)e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    private List stopAll(List managers, StopStrategy stopStrategy) {
        ArrayList<AssertionError> errors = new ArrayList<AssertionError>();
        for (ServiceManager serviceManager : managers) {
            try {
                serviceManager.stop(stopStrategy);
            }
            catch (UnsatisfiedConditionsException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (RuntimeException e) {
                errors.add(new AssertionError((Object)e));
            }
            catch (Error e) {
                errors.add(new AssertionError((Object)e));
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ServiceName serviceName) {
        RegistryFutureTask registryFutureTask;
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        Map map = this.serviceManagers;
        synchronized (map) {
            registryFutureTask = (RegistryFutureTask)this.serviceManagers.get(serviceName);
        }
        try {
            return registryFutureTask != null && registryFutureTask.get() != null;
        }
        catch (InterruptedException e) {
            throw new KernelOperationInterruptedException(e, serviceName, "isRegistered");
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceManager getServiceManager(ServiceName serviceName) throws ServiceNotFoundException {
        RegistryFutureTask registryFutureTask;
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        Map map = this.serviceManagers;
        synchronized (map) {
            registryFutureTask = (RegistryFutureTask)this.serviceManagers.get(serviceName);
        }
        if (registryFutureTask == null) {
            throw new ServiceNotFoundException(serviceName);
        }
        try {
            ServiceManager serviceManager = (ServiceManager)registryFutureTask.get();
            if (serviceManager == null) {
                throw new ServiceNotFoundException(serviceName);
            }
            return serviceManager;
        }
        catch (InterruptedException e) {
            throw new KernelOperationInterruptedException(e, serviceName, "getServiceManager");
        }
        catch (ExecutionException e) {
            throw new ServiceNotFoundException(serviceName);
        }
    }

    public ServiceManager getServiceManager(Class type) {
        SortedSet serviceManagerFutures = this.getServiceManagerFutures(type);
        for (RegistryFutureTask registryFutureTask : serviceManagerFutures) {
            try {
                ServiceManager serviceManager = (ServiceManager)registryFutureTask.get();
                if (serviceManager == null) continue;
                return serviceManager;
            }
            catch (InterruptedException e) {
                throw new KernelOperationInterruptedException(e, registryFutureTask.getServiceName(), "getServiceManagers(java.lang.Class)");
            }
            catch (ExecutionException ignored) {
            }
        }
        return null;
    }

    public List getServiceManagers(Class type) {
        SortedSet serviceManagerFutures = this.getServiceManagerFutures(type);
        ArrayList<ServiceManager> serviceManagers = new ArrayList<ServiceManager>(serviceManagerFutures.size());
        for (RegistryFutureTask registryFutureTask : serviceManagerFutures) {
            try {
                ServiceManager serviceManager = (ServiceManager)registryFutureTask.get();
                if (serviceManager == null) continue;
                serviceManagers.add(serviceManager);
            }
            catch (InterruptedException e) {
                throw new KernelOperationInterruptedException(e, registryFutureTask.getServiceName(), "getServiceManagers(java.lang.Class)");
            }
            catch (ExecutionException ignored) {
            }
        }
        return serviceManagers;
    }

    public synchronized Object getService(Class type) {
        SortedSet serviceManagerFutures = this.getServiceManagerFutures(type);
        for (RegistryFutureTask registryFutureTask : serviceManagerFutures) {
            try {
                Object service;
                ServiceManager serviceManager = (ServiceManager)registryFutureTask.get();
                if (serviceManager == null || (service = serviceManager.getService()) == null) continue;
                return service;
            }
            catch (InterruptedException e) {
                throw new KernelOperationInterruptedException(e, registryFutureTask.getServiceName(), "getService(java.lang.Class)");
            }
            catch (ExecutionException ignored) {
            }
        }
        return null;
    }

    public synchronized List getServices(Class type) {
        List serviceManagers = this.getServiceManagers(type);
        ArrayList<Object> services = new ArrayList<Object>(serviceManagers.size());
        for (ServiceManager serviceManager : serviceManagers) {
            Object service;
            if (serviceManager == null || (service = serviceManager.getService()) == null) continue;
            services.add(service);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedSet getServiceManagerFutures(Class type) {
        TreeSet serviceManagerFutures;
        Map map = this.serviceManagers;
        synchronized (map) {
            serviceManagerFutures = (TreeSet)this.serviceManagersByType.get(type);
            serviceManagerFutures = serviceManagerFutures != null ? new TreeSet(serviceManagerFutures) : new TreeSet();
        }
        return serviceManagerFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceName serviceName, ServiceFactory serviceFactory) throws ServiceAlreadyExistsException, ServiceRegistrationException {
        Map map;
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (serviceFactory == null) {
            throw new NullPointerException("serviceFactory is null");
        }
        if (!serviceFactory.isEnabled()) {
            throw new ServiceRegistrationException(serviceName, (Throwable)new IllegalServiceStateException("A disabled non-restartable service factory can not be registered", serviceName));
        }
        FutureTask registrationTask = null;
        while (registrationTask == null) {
            RegistryFutureTask existingRegistration;
            map = this.serviceManagers;
            synchronized (map) {
                existingRegistration = (RegistryFutureTask)this.serviceManagers.get(serviceName);
                if (existingRegistration == null || existingRegistration.isDone()) {
                    if (existingRegistration != null) {
                        try {
                            boolean alreadyRegistered;
                            boolean bl = alreadyRegistered = existingRegistration.get() != null;
                            if (alreadyRegistered) {
                                throw new ServiceAlreadyExistsException(serviceName);
                            }
                        }
                        catch (InterruptedException e) {
                            throw new KernelOperationInterruptedException(e, serviceName, "registerService");
                        }
                        catch (ExecutionException e) {
                            // empty catch block
                        }
                    }
                    existingRegistration = null;
                    ServiceManager serviceManager = this.serviceManagerFactory.createServiceManager(this.serviceId.getAndIncrement(), serviceName, serviceFactory);
                    registrationTask = RegistryFutureTask.createRegisterTask(serviceManager);
                    this.serviceManagers.put(serviceName, registrationTask);
                    this.addTypeIndex(serviceManager, (RegistryFutureTask)registrationTask);
                }
            }
            if (existingRegistration == null) continue;
            try {
                existingRegistration.get();
            }
            catch (InterruptedException e) {
                throw new KernelOperationInterruptedException(e, serviceName, "registerService");
            }
            catch (ExecutionException e) {
            }
        }
        registrationTask.run();
        try {
            registrationTask.get();
        }
        catch (InterruptedException e) {
            throw new KernelOperationInterruptedException(e, serviceName, "registerService");
        }
        catch (ExecutionException e) {
            map = this.serviceManagers;
            synchronized (map) {
                if (this.serviceManagers.get(serviceName) == registrationTask) {
                    this.serviceManagers.remove(serviceName);
                    this.removeTypeIndex((RegistryFutureTask)registrationTask);
                }
            }
            throw new ServiceRegistrationException(serviceName, e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(ServiceName serviceName, StopStrategy stopStrategy) throws ServiceNotFoundException, ServiceRegistrationException {
        block26: {
            Object existingRegistration;
            if (serviceName == null) {
                throw new NullPointerException("serviceName is null");
            }
            if (stopStrategy == null) {
                throw new NullPointerException("stopStrategy is null");
            }
            FutureTask unregistrationTask = null;
            while (unregistrationTask == null) {
                Map map = this.serviceManagers;
                synchronized (map) {
                    existingRegistration = (RegistryFutureTask)this.serviceManagers.get(serviceName);
                    if (existingRegistration == null) {
                        throw new ServiceNotFoundException(serviceName);
                    }
                    if (((FutureTask)existingRegistration).isDone()) {
                        ServiceManager serviceManager = null;
                        try {
                            serviceManager = (ServiceManager)((FutureTask)existingRegistration).get();
                        }
                        catch (InterruptedException e) {
                            throw new KernelOperationInterruptedException(e, serviceName, "unregisterService");
                        }
                        catch (ExecutionException e) {
                            // empty catch block
                        }
                        if (serviceManager == null) {
                            throw new ServiceNotFoundException(serviceName);
                        }
                        existingRegistration = null;
                        unregistrationTask = RegistryFutureTask.createUnregisterTask(serviceManager, stopStrategy);
                        this.serviceManagers.put(serviceName, unregistrationTask);
                        this.addTypeIndex(serviceManager, (RegistryFutureTask)unregistrationTask);
                    }
                }
                if (existingRegistration == null) continue;
                try {
                    ((FutureTask)existingRegistration).get();
                }
                catch (InterruptedException e) {
                    throw new KernelOperationInterruptedException(e, serviceName, "unregisterService");
                }
                catch (ExecutionException e) {
                }
            }
            unregistrationTask.run();
            try {
                if (unregistrationTask.get() == null) {
                    existingRegistration = this.serviceManagers;
                    synchronized (existingRegistration) {
                        if (this.serviceManagers.get(serviceName) == unregistrationTask) {
                            this.serviceManagers.remove(serviceName);
                            this.removeTypeIndex((RegistryFutureTask)unregistrationTask);
                        }
                        break block26;
                    }
                }
                existingRegistration = unregistrationTask;
                synchronized (existingRegistration) {
                    throw new ServiceRegistrationException(serviceName, ((RegistryFutureTask)unregistrationTask).getThrowable());
                }
            }
            catch (InterruptedException e) {
                throw new KernelOperationInterruptedException(e, serviceName, "unregisterService");
            }
            catch (ExecutionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTypeIndex(ServiceManager serviceManager, RegistryFutureTask registryFutureTask) {
        if (serviceManager == null) {
            throw new NullPointerException("serviceManager is null");
        }
        if (registryFutureTask == null) {
            throw new NullPointerException("serviceManagerFuture is null");
        }
        LinkedHashSet<Class> allTypes = new LinkedHashSet<Class>();
        for (Class serviceType : serviceManager.getServiceTypes()) {
            if (serviceType.isArray()) {
                throw new IllegalArgumentException("Service is an array: serviceName=" + serviceManager.getServiceName() + ", serviceType=" + serviceManager.getServiceTypes());
            }
            allTypes.add(serviceType);
            allTypes.addAll(ServiceManagerRegistry.getAllSuperClasses(serviceType));
            allTypes.addAll(ServiceManagerRegistry.getAllInterfaces(serviceType));
        }
        Map map = this.serviceManagers;
        synchronized (map) {
            for (Class type : allTypes) {
                TreeSet<RegistryFutureTask> futureServiceManagers = (TreeSet<RegistryFutureTask>)this.serviceManagersByType.get(type);
                if (futureServiceManagers == null) {
                    futureServiceManagers = new TreeSet<RegistryFutureTask>();
                    this.serviceManagersByType.put(type, futureServiceManagers);
                }
                futureServiceManagers.add(registryFutureTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTypeIndex(RegistryFutureTask registryFutureTask) {
        if (registryFutureTask == null) {
            throw new NullPointerException("serviceManagerFuture is null");
        }
        Map map = this.serviceManagers;
        synchronized (map) {
            Iterator iterator = this.serviceManagersByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Set serviceManagers = (Set)entry.getValue();
                serviceManagers.remove(registryFutureTask);
                if (!serviceManagers.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private static Set getAllSuperClasses(Class clazz) {
        LinkedHashSet allSuperClasses = new LinkedHashSet();
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            allSuperClasses.add(superClass);
        }
        return allSuperClasses;
    }

    private static Set getAllInterfaces(Class clazz) {
        LinkedHashSet<Class> allInterfaces = new LinkedHashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.addAll(Arrays.asList(clazz.getInterfaces()));
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            if (allInterfaces.contains(intf)) continue;
            allInterfaces.add(intf);
            stack.addAll(Arrays.asList(intf.getInterfaces()));
        }
        return allInterfaces;
    }
}

