/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.transaction.Synchronization;

public class ActiveMQXASession
extends ActiveMQSession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    public ActiveMQXASession(ActiveMQXAConnection connection, SessionId sessionId, int theAcknowlegeMode, boolean dispatchAsync) throws JMSException {
        super(connection, sessionId, theAcknowlegeMode, dispatchAsync);
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Cannot rollback() inside an XASession");
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Cannot commit() inside an XASession");
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this.getTransactionContext();
    }

    public QueueSession getQueueSession() throws JMSException {
        return new ActiveMQQueueSession(this);
    }

    public TopicSession getTopicSession() throws JMSException {
        return new ActiveMQTopicSession(this);
    }

    public void close() throws JMSException {
        if (this.getTransactionContext().isInXATransaction()) {
            this.getTransactionContext().addSynchronization(new Synchronization(){

                public void afterCommit() throws Exception {
                    ActiveMQXASession.this.doClose();
                }

                public void afterRollback() throws Exception {
                    ActiveMQXASession.this.doClose();
                }
            });
        }
    }

    void doClose() throws JMSException {
        super.close();
    }

    protected void doStartTransaction() throws JMSException {
        if (!this.getTransactionContext().isInXATransaction()) {
            throw new JMSException("Session's XAResource has not been enlisted in a distributed transaction.");
        }
    }
}

