/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicemix.beanflow.CallableActivity;
import org.apache.servicemix.beanflow.JoinAll;
import org.apache.servicemix.beanflow.JoinSupport;
import org.apache.servicemix.beanflow.ProxyActivity;
import org.apache.servicemix.beanflow.support.CallablesFactory;
import org.apache.servicemix.beanflow.support.FindCallableMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelActivity<T>
extends ProxyActivity {
    private JoinSupport joinActivity;
    private List<CallableActivity<T>> activities;
    private AtomicBoolean started = new AtomicBoolean();
    private Object lock = new Object();
    private CountDownLatch countDownLatch;

    public static ParallelActivity newParallelMethodActivity(Executor executor, Object bean) {
        return ParallelActivity.newParallelMethodActivity(new JoinAll(), executor, bean);
    }

    public static ParallelActivity newParallelMethodActivity(JoinSupport join, Executor executor, Object bean) {
        return new ParallelActivity(join, executor, new FindCallableMethods(bean));
    }

    public ParallelActivity(JoinSupport activity, Executor executor, CallablesFactory<T> callablesFactory) {
        this(activity, executor, callablesFactory.createCallables());
    }

    public ParallelActivity(JoinSupport activity, Executor executor, List<Callable<T>> callables) {
        super(activity);
        this.joinActivity = activity;
        this.activities = new ArrayList<CallableActivity<T>>();
        for (Callable<T> callable : callables) {
            this.activities.add(new CallableActivity<T>(executor, callable));
        }
    }

    public ParallelActivity(JoinSupport activity, List<CallableActivity<T>> activities) {
        super(activity);
        this.joinActivity = activity;
        this.activities = activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Future<T>> getFutures() {
        ArrayList<Future<T>> answer = new ArrayList<Future<T>>();
        Object object = this.lock;
        synchronized (object) {
            for (CallableActivity<T> activity : this.activities) {
                answer.add(activity.getFuture());
            }
        }
        return answer;
    }

    @Override
    public void start() {
        super.start();
        this.init();
    }

    @Override
    public void startWithTimeout(Timer timer, long timeout) {
        this.init();
        super.startWithTimeout(timer, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        try {
            CountDownLatch latch = this.getCountDownLatch();
            latch.countDown();
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.resetCountDownLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(long millis) {
        try {
            CountDownLatch latch = this.getCountDownLatch();
            latch.countDown();
            boolean bl = latch.await(millis, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.resetCountDownLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCountDownLatch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.countDownLatch != null && this.countDownLatch.getCount() == 0L) {
                this.countDownLatch = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch getCountDownLatch() {
        Object object = this.lock;
        synchronized (object) {
            int count = this.activities.size();
            if (this.countDownLatch == null) {
                this.countDownLatch = new CountDownLatch(count);
            }
            return this.countDownLatch;
        }
    }

    private void init() {
        if (this.started.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    protected void doStart() {
        for (CallableActivity<T> activity : this.activities) {
            this.joinActivity.fork(activity);
        }
    }
}

