/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.support;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.beanflow.State;
import org.apache.servicemix.beanflow.support.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldIntrospector
implements Introspector {
    private static final Log log = LogFactory.getLog(FieldIntrospector.class);

    @Override
    public Iterator<State> iterator(Object owner) {
        ArrayList<State> list = new ArrayList<State>();
        for (Class<?> type = owner.getClass(); type != null && type != Object.class; type = type.getSuperclass()) {
            Field[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object value;
                block4: {
                    Field field = fields[i];
                    value = null;
                    try {
                        field.setAccessible(true);
                        value = field.get(owner);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)("Could not access field: " + field + " reason: " + e), (Throwable)e);
                    }
                }
                State state = this.toState(value);
                if (state == null) continue;
                list.add(state);
            }
        }
        return list.iterator();
    }

    protected State toState(Object value) {
        if (value instanceof State) {
            return (State)value;
        }
        return null;
    }
}

