/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.util;

import java.util.Timer;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.beanflow.Activity;

public abstract class ActivityTestSupport
extends TestCase {
    private static final Log log = LogFactory.getLog(ActivityTestSupport.class);
    protected Timer timer = new Timer();
    protected long timeout = 500L;

    protected void assertStarted(Activity activity) throws Exception {
        this.assertNotFailed(activity);
        ActivityTestSupport.assertEquals((String)"Transition", (Object)((Object)Activity.Transitions.Started), (Object)((Object)activity.getState().get()));
    }

    protected void assertStopped(Activity activity) throws Exception {
        this.assertNotFailed(activity);
        ActivityTestSupport.assertEquals((String)"Transition", (Object)((Object)Activity.Transitions.Stopped), (Object)((Object)activity.getState().get()));
        ActivityTestSupport.assertTrue((String)("Flow should be stopped but is: " + (Object)((Object)activity.getState().get())), (boolean)activity.isStopped());
        ActivityTestSupport.assertTrue((String)"Flow should not have failed", (!activity.isFailed() ? 1 : 0) != 0);
    }

    protected void assertNotFailed(Activity activity) throws Exception {
        ActivityTestSupport.assertTrue((String)("Should not have failed: " + activity.getFailedReason() + " exception: " + activity.getFailedException()), (!activity.isFailed() ? 1 : 0) != 0);
        Throwable failedException = activity.getFailedException();
        if (failedException != null) {
            if (failedException instanceof Exception) {
                throw (Exception)failedException;
            }
            throw new RuntimeException(failedException);
        }
    }

    protected void assertFailed(Activity activity) {
        ActivityTestSupport.assertEquals((String)"Transition", (Object)((Object)Activity.Transitions.Failed), (Object)((Object)activity.getState().get()));
        ActivityTestSupport.assertTrue((String)("Flow should be stopped but is: " + (Object)((Object)activity.getState().get())), (boolean)activity.isStopped());
        ActivityTestSupport.assertTrue((String)"Flow should have failed", (boolean)activity.isFailed());
        log.info((Object)("The activity failed due to: " + activity.getFailedReason()));
    }

    protected void startActivity(Activity activity, long timeout) throws Exception {
        ActivityTestSupport.assertTrue((String)"activity should not be stopped", (!activity.isStopped() ? 1 : 0) != 0);
        ActivityTestSupport.assertTrue((String)"activity should not have failed", (!activity.isFailed() ? 1 : 0) != 0);
        ActivityTestSupport.assertEquals((String)"Transition", (Object)((Object)Activity.Transitions.Initialised), (Object)((Object)activity.getState().get()));
        activity.startWithTimeout(this.timer, timeout);
        this.assertStarted(activity);
    }
}

