/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.servicemix.beanflow.Activity;
import org.apache.servicemix.beanflow.DefaultState;
import org.apache.servicemix.beanflow.State;
import org.apache.servicemix.beanflow.support.FieldIntrospector;
import org.apache.servicemix.beanflow.support.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActivity
implements Runnable,
Activity {
    private State<Activity.Transitions> state = new DefaultState<Activity.Transitions>(Activity.Transitions.Initialised);
    private Introspector introspector = new FieldIntrospector();
    private String failedReason;
    private Throwable failedException;

    @Override
    public void start() {
        if (this.state.compareAndSet(Activity.Transitions.Initialised, Activity.Transitions.Starting)) {
            this.doStart();
            this.state.compareAndSet(Activity.Transitions.Starting, Activity.Transitions.Started);
        }
    }

    @Override
    public void stop() {
        if (!this.state.isAny((Activity.Transitions[])new Activity.Transitions[]{Activity.Transitions.Stopped, Activity.Transitions.Failed})) {
            this.state.set(Activity.Transitions.Stopped);
            this.doStop();
        }
    }

    @Override
    public void fail(String reason) {
        this.failedReason = reason;
        this.state.set(Activity.Transitions.Failed);
        this.doStop();
    }

    public void fail(String message, Throwable e) {
        this.fail(message);
        this.failedException = e;
    }

    @Override
    public State<Activity.Transitions> getState() {
        return this.state;
    }

    @Override
    public boolean isStopped() {
        return this.state.isAny((Activity.Transitions[])new Activity.Transitions[]{Activity.Transitions.Stopped, Activity.Transitions.Failed});
    }

    @Override
    public boolean isFailed() {
        return this.state.is(Activity.Transitions.Failed);
    }

    @Override
    public String getFailedReason() {
        return this.failedReason;
    }

    @Override
    public Throwable getFailedException() {
        return this.failedException;
    }

    @Override
    public void onStop(final Runnable runnable) {
        this.getState().addRunnable(new Runnable(){

            public void run() {
                if (AbstractActivity.this.isStopped()) {
                    runnable.run();
                }
            }
        });
    }

    @Override
    public void onFailure(final Runnable runnable) {
        this.getState().addRunnable(new Runnable(){

            public void run() {
                if (AbstractActivity.this.isFailed()) {
                    runnable.run();
                }
            }
        });
    }

    @Override
    public void join() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.onStop(new Runnable(){

            public void run() {
                latch.countDown();
            }
        });
        while (!this.isStopped()) {
            try {
                latch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean join(int time, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.onStop(new Runnable(){

            public void run() {
                latch.countDown();
            }
        });
        if (!this.isStopped()) {
            try {
                latch.await(time, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.isStopped();
    }

    protected void doStart() {
        this.addListeners(this);
    }

    protected void doStop() {
        this.removeListeners(this);
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void setIntrospector(Introspector introspector) {
        this.introspector = introspector;
    }

    protected void addListeners(Runnable listener) {
        if (this.introspector != null) {
            Iterator<State> iter = this.introspector.iterator(this);
            while (iter.hasNext()) {
                iter.next().addRunnable(listener);
            }
        }
    }

    protected void removeListeners(Runnable listener) {
        if (this.introspector != null) {
            Iterator<State> iter = this.introspector.iterator(this);
            while (iter.hasNext()) {
                iter.next().removeRunnable(listener);
            }
        }
    }
}

