/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.deployment.Services;
import org.apache.servicemix.jbi.event.ServiceUnitEvent;
import org.apache.servicemix.jbi.event.ServiceUnitListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceUnitMBean;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.OperationInfoHelper;

public class ServiceUnitLifeCycle
implements ServiceUnitMBean,
MBeanInfoProvider {
    private static final Log LOG = LogFactory.getLog(ServiceUnitLifeCycle.class);
    private ServiceUnit serviceUnit;
    private String currentState = "Shutdown";
    private String serviceAssembly;
    private Registry registry;
    private PropertyChangeListener listener;
    private Services services;
    private File rootDir;

    public ServiceUnitLifeCycle(ServiceUnit serviceUnit, String serviceAssembly, Registry registry, File rootDir) {
        this.serviceUnit = serviceUnit;
        this.serviceAssembly = serviceAssembly;
        this.registry = registry;
        this.rootDir = rootDir;
        Descriptor d = DescriptorFactory.buildDescriptor(rootDir);
        if (d != null) {
            this.services = d.getServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DeploymentException {
        LOG.info((Object)("Initializing service unit: " + this.getName()));
        this.checkComponentStarted("init");
        ServiceUnitManager sum = this.getServiceUnitManager();
        File path = this.getServiceUnitRootPath();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getComponentClassLoader());
            sum.init(this.getName(), path.getAbsolutePath());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.currentState = "Stopped";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DeploymentException {
        LOG.info((Object)("Starting service unit: " + this.getName()));
        this.checkComponentStarted("start");
        ServiceUnitManager sum = this.getServiceUnitManager();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getComponentClassLoader());
            sum.start(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.currentState = "Started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws DeploymentException {
        LOG.info((Object)("Stopping service unit: " + this.getName()));
        this.checkComponentStarted("stop");
        ServiceUnitManager sum = this.getServiceUnitManager();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getComponentClassLoader());
            sum.stop(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.currentState = "Stopped";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws DeploymentException {
        LOG.info((Object)("Shutting down service unit: " + this.getName()));
        this.checkComponentStartedOrStopped("shutDown");
        ServiceUnitManager sum = this.getServiceUnitManager();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getComponentClassLoader());
            sum.shutDown(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.currentState = "Shutdown";
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public boolean isShutDown() {
        return this.currentState.equals("Shutdown");
    }

    public boolean isStopped() {
        return this.currentState.equals("Stopped");
    }

    public boolean isStarted() {
        return this.currentState.equals("Started");
    }

    public String getName() {
        return this.serviceUnit.getIdentification().getName();
    }

    public String getDescription() {
        return this.serviceUnit.getIdentification().getDescription();
    }

    public String getComponentName() {
        return this.serviceUnit.getTarget().getComponentName();
    }

    public String getServiceAssembly() {
        return this.serviceAssembly;
    }

    public String getDescriptor() {
        File suDir = this.getServiceUnitRootPath();
        return DescriptorFactory.getDescriptorAsText(suDir);
    }

    public Services getServices() {
        return this.services;
    }

    protected void checkComponentStarted(String task) throws DeploymentException {
        String componentName = this.getComponentName();
        String suName = this.getName();
        ComponentMBeanImpl lcc = this.registry.getComponent(componentName);
        if (lcc == null) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " is not installed");
        }
        if (!lcc.isStarted()) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " is not started");
        }
        if (lcc.getServiceUnitManager() == null) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " does not accept deployments");
        }
    }

    protected void checkComponentStartedOrStopped(String task) throws DeploymentException {
        String componentName = this.getComponentName();
        String suName = this.getName();
        ComponentMBeanImpl lcc = this.registry.getComponent(componentName);
        if (lcc == null) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " is not installed");
        }
        if (!lcc.isStarted() && !lcc.isStopped()) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " is not started");
        }
        if (lcc.getServiceUnitManager() == null) {
            throw ManagementSupport.componentFailure("deploy", componentName, "Target component " + componentName + " for service unit " + suName + " does not accept deployments");
        }
    }

    protected File getServiceUnitRootPath() {
        return this.rootDir;
    }

    protected ServiceUnitManager getServiceUnitManager() {
        ComponentMBeanImpl lcc = this.registry.getComponent(this.getComponentName());
        return lcc.getServiceUnitManager();
    }

    protected ClassLoader getComponentClassLoader() {
        ComponentMBeanImpl lcc = this.registry.getComponent(this.getComponentName());
        return lcc.getComponent().getClass().getClassLoader();
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "currentState", "current state of the service unit");
        helper.addAttribute(this.getObjectToManage(), "name", "name of the service unit");
        helper.addAttribute(this.getObjectToManage(), "componentName", "component name of the service unit");
        helper.addAttribute(this.getObjectToManage(), "serviceAssembly", "service assembly name of the service unit");
        helper.addAttribute(this.getObjectToManage(), "description", "description of the service unit");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "getDescriptor", "retrieve the jbi descriptor for this unit");
        return helper.getOperationInfos();
    }

    public Object getObjectToManage() {
        return this;
    }

    public String getType() {
        return "ServiceUnit";
    }

    public String getSubType() {
        return this.getComponentName();
    }

    public void setPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    protected void firePropertyChanged(String name, Object oldValue, Object newValue) {
        PropertyChangeListener l = this.listener;
        if (l != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
            l.propertyChange(event);
        }
    }

    public String getKey() {
        return this.getComponentName() + "/" + this.getName();
    }

    protected void fireEvent(int type) {
        ServiceUnitEvent event = new ServiceUnitEvent(this, type);
        ServiceUnitListener[] listeners = (ServiceUnitListener[])this.registry.getContainer().getListeners(ServiceUnitListener.class);
        block5: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 1: {
                    listeners[i].unitStarted(event);
                    continue block5;
                }
                case 2: {
                    listeners[i].unitStopped(event);
                    continue block5;
                }
                case 3: {
                    listeners[i].unitShutDown(event);
                    continue block5;
                }
            }
        }
    }
}

