/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework.support;

import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.support.EndpointProcessor;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.w3c.dom.Document;

public class WSDL1Processor
implements EndpointProcessor {
    public static final String WSDL1_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final Log LOG = LogFactory.getLog(WSDL1Processor.class);
    private Registry registry;

    public void init(Registry reg) {
        this.registry = reg;
    }

    public void process(InternalEndpoint serviceEndpoint) {
        block14: {
            try {
                Document document = this.registry.getEndpointDescriptor(serviceEndpoint);
                if (document == null || document.getDocumentElement() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " has no service description"));
                    }
                    return;
                }
                if (!WSDL1_NAMESPACE.equals(document.getDocumentElement().getNamespaceURI())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " has a non WSDL1 service description"));
                    }
                    return;
                }
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                Definition definition = reader.readWSDL(null, document);
                if (definition.getPortTypes().keySet().size() == 1 && definition.getServices().keySet().size() == 0) {
                    PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
                    QName interfaceName = portType.getQName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                } else {
                    Service service = definition.getService(serviceEndpoint.getServiceName());
                    if (service == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching service found in " + definition.getServices().keySet()));
                        return;
                    }
                    Port port = service.getPort(serviceEndpoint.getEndpointName());
                    if (port == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching endpoint found in " + service.getPorts().keySet()));
                        return;
                    }
                    if (port.getBinding() == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no binding found"));
                        return;
                    }
                    if (port.getBinding().getPortType() == null) {
                        LOG.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no port type found"));
                        return;
                    }
                    QName interfaceName = port.getBinding().getPortType().getQName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error retrieving interfaces from service description: " + e.getMessage()));
                if (!LOG.isDebugEnabled()) break block14;
                LOG.debug((Object)"Error retrieving interfaces from service description", (Throwable)e);
            }
        }
    }
}

