/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jmx.ConnectorServerFactoryBean;
import org.apache.servicemix.jbi.jmx.RmiRegistryFactoryBean;
import org.apache.servicemix.jbi.management.ManagementContext;

class MBeanServerContext {
    public static final String DEFAULT_DOMAIN = "org.apache.activemq";
    private static final Log LOG = LogFactory.getLog(ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = "org.apache.activemq";
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer;
    private boolean createConnector = true;
    private boolean findTigerMbeanServer;
    private int connectorPort = 1099;
    private String connectorPath = "/jmxrmi";
    private AtomicBoolean started = new AtomicBoolean(false);
    private ConnectorServerFactoryBean connectorServerFactoryBean;
    private RmiRegistryFactoryBean rmiRegistryFactoryBean;

    public MBeanServerContext() {
        this(null);
    }

    public MBeanServerContext(MBeanServer server) {
        this.beanServer = server;
    }

    public void start() throws IOException {
        block8: {
            if (this.started.compareAndSet(false, true)) {
                if (this.getMBeanServer() == null) {
                    return;
                }
                if (this.createConnector) {
                    try {
                        this.rmiRegistryFactoryBean = new RmiRegistryFactoryBean();
                        this.rmiRegistryFactoryBean.setPort(this.connectorPort);
                        this.rmiRegistryFactoryBean.afterPropertiesSet();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to start rmi registry: " + e.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Failed to start rmi registry", (Throwable)e);
                        }
                        return;
                    }
                    try {
                        this.connectorServerFactoryBean = new ConnectorServerFactoryBean();
                        this.connectorServerFactoryBean.setObjectName("connector:name=rmi");
                        this.connectorServerFactoryBean.setServer(this.getMBeanServer());
                        String serviceUrl = "service:jmx:rmi:///jndi/rmi://localhost:" + this.connectorPort + this.connectorPath;
                        this.connectorServerFactoryBean.setServiceUrl(serviceUrl);
                        this.connectorServerFactoryBean.afterPropertiesSet();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to start jmx connector: " + e.getMessage()));
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)"Failed to create jmx connector", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (this.started.compareAndSet(true, false)) {
            ArrayList<MBeanServer> list;
            if (this.connectorServerFactoryBean != null) {
                try {
                    this.connectorServerFactoryBean.destroy();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to stop jmx connector: " + e.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Failed to stop jmx connector", (Throwable)e);
                    }
                }
                finally {
                    this.connectorServerFactoryBean = null;
                }
            }
            if (this.rmiRegistryFactoryBean != null) {
                try {
                    this.rmiRegistryFactoryBean.destroy();
                }
                catch (RemoteException e) {
                    LOG.warn((Object)("Failed to stop rmi registry: " + e.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Failed to stop rmi registry", (Throwable)e);
                    }
                }
                finally {
                    this.rmiRegistryFactoryBean = null;
                }
            }
            if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
                MBeanServerFactory.releaseMBeanServer(this.beanServer);
            }
        }
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public void setMBeanServer(MBeanServer mbs) {
        this.beanServer = mbs;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public boolean isFindTigerMbeanServer() {
        return this.findTigerMbeanServer;
    }

    public void setFindTigerMbeanServer(boolean findTigerMbeanServer) {
        this.findTigerMbeanServer = findTigerMbeanServer;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + MBeanServerContext.sanitizeString(type) + ",name=" + MBeanServerContext.sanitizeString(name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Couldn't create ObjectName from: " + type + " , " + name));
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + MBeanServerContext.getRelativeName(containerName, theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        if (this.beanServer != null && this.beanServer.isRegistered(name)) {
            this.beanServer.unregisterMBean(name);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            if (this.useMBeanServer) {
                ArrayList<MBeanServer> list;
                if (this.findTigerMbeanServer) {
                    result = MBeanServerContext.findTigerMBeanServer();
                }
                if (result == null && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                    result = (MBeanServer)list.get(0);
                }
            }
            if (result == null && this.createMBeanServer) {
                result = this.createMBeanServer();
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Object)"Could not load MBeanServer", (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error((Object)"Failed to initialize MBeanServer", e);
        }
        return result;
    }

    public static MBeanServer findTigerMBeanServer() {
        block6: {
            String name = "java.lang.management.ManagementFactory";
            Class type = MBeanServerContext.loadClass(name, ManagementContext.class.getClassLoader());
            if (type != null) {
                try {
                    Method method = type.getMethod("getPlatformMBeanServer", new Class[0]);
                    if (method != null) {
                        Object answer = method.invoke(null, new Object[0]);
                        if (answer instanceof MBeanServer) {
                            return (MBeanServer)answer;
                        }
                        LOG.warn((Object)("Could not cast: " + answer + " into an MBeanServer. There must be some classloader strangeness in town"));
                        break block6;
                    }
                    LOG.warn((Object)("Method getPlatformMBeanServer() does not appear visible on type: " + type.getName()));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to call getPlatformMBeanServer() due to: " + e), (Throwable)e);
                }
            } else {
                LOG.trace((Object)("Class not found: " + name + " so probably running on Java 1.4"));
            }
        }
        return null;
    }

    private static Class loadClass(String name, ClassLoader loader) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    protected MBeanServer createMBeanServer() throws MalformedObjectNameException, IOException {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
        this.locallyCreateMBeanServer = true;
        return mbeanServer;
    }

    public String getConnectorPath() {
        return this.connectorPath;
    }

    public void setConnectorPath(String connectorPath) {
        this.connectorPath = connectorPath;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }
}

