/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.login;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.security.GroupPrincipal;
import org.apache.servicemix.jbi.security.UserPrincipal;
import org.apache.servicemix.jbi.security.login.CertificateCallback;

public class CertificatesLoginModule
implements LoginModule {
    private static final String USER_FILE = "org.apache.servicemix.security.certificates.user";
    private static final String GROUP_FILE = "org.apache.servicemix.security.certificates.group";
    private static final Log LOG = LogFactory.getLog(CertificatesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private String usersFile;
    private String groupsFile;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private String user;
    private Set principals = new HashSet();
    private File baseDir;

    public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.baseDir = System.getProperty("java.security.auth.login.config") != null ? new File(System.getProperty("java.security.auth.login.config")).getParentFile() : new File(".");
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.usersFile = (String)options.get(USER_FILE) + "";
        this.groupsFile = (String)options.get(GROUP_FILE) + "";
        if (this.debug) {
            LOG.debug((Object)("Initialized debug=" + this.debug + " usersFile=" + this.usersFile + " groupsFile=" + this.groupsFile + " basedir=" + this.baseDir));
        }
    }

    public boolean login() throws LoginException {
        File f = new File(this.baseDir, this.usersFile);
        try {
            this.users.load(new FileInputStream(f));
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        f = new File(this.baseDir, this.groupsFile);
        try {
            this.groups.load(new FileInputStream(f));
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load group properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        X509Certificate cert = ((CertificateCallback)callbacks[0]).getCertificate();
        if (cert == null) {
            throw new FailedLoginException("Unable to retrieve certificate");
        }
        X500Principal principal = cert.getSubjectX500Principal();
        String certName = principal.getName();
        for (Map.Entry<Object, Object> entry : this.users.entrySet()) {
            if (!certName.equals(entry.getValue())) continue;
            this.user = (String)entry.getKey();
            this.principals.add(principal);
            if (this.debug) {
                LOG.debug((Object)("login " + this.user));
            }
            return true;
        }
        throw new FailedLoginException();
    }

    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.user));
        Enumeration<Object> enumeration = this.groups.keys();
        block0: while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] userList = (this.groups.getProperty(name) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!this.user.equals(userList[i])) continue;
                this.principals.add(new GroupPrincipal(name));
                continue block0;
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            LOG.debug((Object)"commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug((Object)"abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug((Object)"logout");
        }
        return true;
    }

    private void clear() {
        this.groups.clear();
        this.user = null;
    }
}

