/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.view.DotViewEndpointListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotViewFlowListener
extends DotViewEndpointListener
implements ExchangeListener,
ComponentListener {
    private Map<String, Map<String, Boolean>> flow;
    private Set<String> flowLinks;
    private Set<String> usedComponents;
    private Set<String> componentsAsConsumer;
    private boolean displayComponents = true;

    public DotViewFlowListener() {
        this.setFile("ServiceMixFlow.dot");
        this.flow = new ConcurrentHashMap<String, Map<String, Boolean>>();
        this.flowLinks = new CopyOnWriteArraySet<String>();
        this.usedComponents = new CopyOnWriteArraySet<String>();
        this.componentsAsConsumer = new CopyOnWriteArraySet<String>();
    }

    @Override
    protected void generateFile(PrintWriter writer) throws Exception {
        writer.println("digraph \"Apache ServiceMix\" {");
        writer.println();
        writer.println("label = \"Apache ServiceMix flow\";");
        writer.println("node [ shape = box, style = \"rounded,filled\", fontname = \"Helvetica-Oblique\", fontsize = 8 ];");
        writer.println();
        ArrayList<String> brokerLinks = new ArrayList<String>();
        Registry registry = this.getContainer().getRegistry();
        Collection<ComponentMBeanImpl> components = registry.getComponents();
        for (ComponentMBeanImpl component : components) {
            ServiceEndpoint[] ses = registry.getEndpointRegistry().getAllEndpointsForComponent(component.getComponentNameSpace());
            String name = component.getName();
            if (!this.usedComponents.contains(name)) continue;
            if (this.isDisplayComponents()) {
                String id = this.encode(name);
                writer.println("subgraph cluster_" + id + " {");
                writer.println("  label=\"" + name + "\";");
                if (this.componentsAsConsumer.contains(name)) {
                    writer.println("  " + id + " [ fillcolor = gray, label = \"" + name + "\" ];");
                }
            }
            for (int i = 0; i < ses.length; ++i) {
                String key = EndpointSupport.getUniqueKey(ses[i]);
                String epname = this.formatEndpoint(key);
                if (!this.isDisplayComponents()) {
                    epname = epname + "\\n" + name;
                }
                String color = "lightgray";
                if (epname.startsWith("internal")) {
                    epname = epname.substring(10);
                    color = "#6699ff";
                } else if (epname.startsWith("external")) {
                    epname = epname.substring(10);
                    color = "#66ccff";
                } else if (epname.startsWith("dynamic")) {
                    epname = epname.substring(9);
                    color = "#6666ff";
                } else if (epname.startsWith("linked")) {
                    epname = epname.substring(8);
                    color = "#66ffff";
                } else {
                    color = "#f3f3f3";
                }
                String epid = this.encode(key);
                writer.println("  " + epid + " [fillcolor = \"" + color + "\", label=\"" + epname + "\"];");
            }
            if (!this.isDisplayComponents()) continue;
            writer.println("}");
        }
        writer.println();
        this.generateLinks(writer, brokerLinks);
        writer.println();
        this.generateLinks(writer, this.flowLinks);
        writer.println("}");
    }

    @Override
    public void exchangeSent(ExchangeEvent event) {
        MessageExchange me = event.getExchange();
        if (me.getEndpoint() instanceof AbstractServiceEndpoint && me instanceof MessageExchangeImpl) {
            MessageExchangeImpl mei = (MessageExchangeImpl)me;
            String source = (String)me.getProperty("org.apache.servicemix.senderEndpoint");
            if (source == null) {
                source = mei.getSourceId().getName();
                this.componentsAsConsumer.add(source);
            } else {
                ServiceEndpoint[] ses = this.getContainer().getRegistry().getEndpointRegistry().getAllEndpointsForComponent(mei.getSourceId());
                for (int i = 0; i < ses.length; ++i) {
                    if (!EndpointSupport.getKey(ses[i]).equals(source)) continue;
                    source = EndpointSupport.getUniqueKey(ses[i]);
                    break;
                }
            }
            this.usedComponents.add(mei.getSourceId().getName());
            if (((AbstractServiceEndpoint)mei.getEndpoint()).getComponentNameSpace() != null) {
                this.usedComponents.add(((AbstractServiceEndpoint)mei.getEndpoint()).getComponentNameSpace().getName());
            }
            String dest = EndpointSupport.getUniqueKey(mei.getEndpoint());
            Map<String, Boolean> componentFlow = this.createSource(source);
            if (componentFlow.put(dest, Boolean.TRUE) == null) {
                this.flowLinks.add(this.encode(source) + " -> " + this.encode(dest));
                this.viewIsDirty(mei.getEndpoint());
            }
        }
    }

    @Override
    public void exchangeAccepted(ExchangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Boolean> createSource(String name) {
        Map<String, Map<String, Boolean>> map = this.flow;
        synchronized (map) {
            Map<String, Boolean> componentFlow = this.flow.get(name);
            if (componentFlow == null) {
                componentFlow = new ConcurrentHashMap<String, Boolean>();
                this.flow.put(name, componentFlow);
            }
            return componentFlow;
        }
    }

    @Override
    public void internalEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getUniqueKey(event.getEndpoint());
        this.createSource(key);
        super.internalEndpointRegistered(event);
    }

    @Override
    public void externalEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getUniqueKey(event.getEndpoint());
        this.createSource(key);
        super.externalEndpointRegistered(event);
    }

    @Override
    public void linkedEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getUniqueKey(event.getEndpoint());
        this.createSource(key);
        super.linkedEndpointRegistered(event);
    }

    @Override
    public void componentInstalled(ComponentEvent event) {
        this.createSource(event.getComponent().getName());
    }

    @Override
    public void componentInitialized(ComponentEvent event) {
        this.createSource(event.getComponent().getName());
    }

    @Override
    public void componentStarted(ComponentEvent event) {
    }

    @Override
    public void componentStopped(ComponentEvent event) {
    }

    @Override
    public void componentShutDown(ComponentEvent event) {
    }

    @Override
    public void componentUninstalled(ComponentEvent event) {
    }

    public boolean isDisplayComponents() {
        return this.displayComponents;
    }

    public void setDisplayComponents(boolean displayComponents) {
        this.displayComponents = displayComponents;
    }
}

