/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.jms.JmsMarshaler;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.RuntimeJBIException;

public class JmsInBinding
extends ComponentSupport
implements MessageListener,
MessageExchangeListener {
    private static final Log log = LogFactory.getLog(JmsInBinding.class);
    private JmsMarshaler marshaler = new JmsMarshaler();
    private boolean synchronous = false;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public JmsMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public void onMessage(Message jmsMessage) {
        block6: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received: " + jmsMessage));
            }
            try {
                InOnly messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
                NormalizedMessage inMessage = messageExchange.createMessage();
                try {
                    this.marshaler.toNMS(inMessage, jmsMessage);
                    messageExchange.setInMessage(inMessage);
                    if (this.synchronous) {
                        this.getDeliveryChannel().sendSync((MessageExchange)messageExchange);
                        break block6;
                    }
                    this.getDeliveryChannel().send((MessageExchange)messageExchange);
                }
                catch (JMSException e) {
                    messageExchange.setError((Exception)((Object)e));
                    messageExchange.setStatus(ExchangeStatus.ERROR);
                }
            }
            catch (JBIException e) {
                throw new RuntimeJBIException(e);
            }
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
    }
}

