/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import javax.jbi.JBIException;
import javax.jms.MessageListener;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.apache.servicemix.components.jms.JmsInBinding;
import org.jencks.JCAConnector;
import org.jencks.JCAContainer;
import org.jencks.SingletonEndpointFactory;
import org.springframework.beans.factory.BeanNameAware;

public class JmsInUsingJCABinding
extends JmsInBinding
implements BeanNameAware {
    private JCAContainer jcaContainer;
    private ActivationSpec activationSpec;
    private TransactionManager transactionManager;
    private JCAConnector jcaConnector;
    private String name;

    protected void init() throws JBIException {
        if (this.jcaContainer == null) {
            throw new IllegalArgumentException("Must specify a jcaContainer property");
        }
        if (this.activationSpec == null) {
            throw new IllegalArgumentException("Must specify an activationSpec property");
        }
        this.jcaConnector = this.jcaContainer.addConnector();
        this.jcaConnector.setActivationSpec(this.activationSpec);
        if (this.transactionManager == null) {
            this.transactionManager = (TransactionManager)this.getContext().getTransactionManager();
        }
        if (this.transactionManager != null) {
            this.jcaConnector.setTransactionManager(this.transactionManager);
        }
        SingletonEndpointFactory ef = new SingletonEndpointFactory((MessageListener)this, this.transactionManager);
        ef.setName(this.name);
        this.jcaConnector.setEndpointFactory((MessageEndpointFactory)ef);
        try {
            this.jcaConnector.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new JBIException("Unable to initialize jca connector", (Throwable)e);
        }
        super.init();
    }

    public void start() throws JBIException {
        try {
            this.jcaConnector.start();
        }
        catch (Exception e) {
            throw new JBIException("Unable to start jca connector", (Throwable)e);
        }
        super.start();
    }

    public void stop() throws JBIException {
        super.stop();
        try {
            this.jcaConnector.destroy();
        }
        catch (Exception e) {
            throw new JBIException("Unable to stop jca connector", (Throwable)e);
        }
    }

    public JCAContainer getJcaContainer() {
        return this.jcaContainer;
    }

    public void setJcaContainer(JCAContainer jcaContainer) {
        this.jcaContainer = jcaContainer;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public JCAConnector getJcaConnector() {
        return this.jcaConnector;
    }

    public void setBeanName(String name) {
        this.name = name;
    }
}

