/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceCondition;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.standard.StandardServiceConditionContext;

public class AggregateCondition {
    private final Kernel kernel;
    private final ServiceName serviceName;
    private final ClassLoader classLoader;
    private final Lock lock;
    private final Map conditions = new HashMap();
    private final Condition satisfiedSignal;
    private boolean destroyed = false;

    public AggregateCondition(Kernel kernel, ServiceName serviceName, ClassLoader classLoader, Lock lock, Set conditions) {
        this.kernel = kernel;
        this.serviceName = serviceName;
        this.classLoader = classLoader;
        this.lock = lock;
        this.satisfiedSignal = lock.newCondition();
        if (conditions == null) {
            throw new NullPointerException("conditions is null");
        }
        for (ServiceCondition serviceCondition : conditions) {
            this.addCondition(serviceCondition);
        }
    }

    protected Set getConditions() {
        return new HashSet(this.conditions.keySet());
    }

    protected final void addCondition(ServiceCondition condition) {
        if (!this.conditions.containsKey(condition)) {
            StandardServiceConditionContext context = new StandardServiceConditionContext(this.kernel, this.serviceName, this.classLoader, this.lock, this.satisfiedSignal);
            condition.initialize(context);
            this.conditions.put(condition, context);
        }
    }

    protected final void removeCondition(ServiceCondition condition) {
        if (this.conditions.remove(condition) != null) {
            condition.destroy();
        }
    }

    public void initialize() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed");
        }
        for (Map.Entry entry : this.conditions.entrySet()) {
            ServiceCondition condition = (ServiceCondition)entry.getKey();
            StandardServiceConditionContext context = (StandardServiceConditionContext)entry.getValue();
            condition.initialize(context);
        }
    }

    public Set getUnsatisfied() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed");
        }
        HashSet<ServiceCondition> unsatisfied = new HashSet<ServiceCondition>();
        for (Map.Entry entry : this.conditions.entrySet()) {
            ServiceCondition condition = (ServiceCondition)entry.getKey();
            StandardServiceConditionContext context = (StandardServiceConditionContext)entry.getValue();
            if (context.isSatisfied()) continue;
            if (condition.isSatisfied()) {
                context.setSatisfied();
                continue;
            }
            unsatisfied.add(condition);
        }
        if (unsatisfied.isEmpty()) {
            this.satisfiedSignal.signalAll();
        }
        return unsatisfied;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public List destroy() {
        ArrayList<Throwable> stopErrors = new ArrayList<Throwable>();
        if (!this.destroyed) {
            this.destroyed = true;
            for (ServiceCondition condition : this.conditions.keySet()) {
                try {
                    condition.destroy();
                }
                catch (RuntimeException stopError) {
                    stopErrors.add(stopError);
                }
                catch (Error stopError) {
                    stopErrors.add(stopError);
                }
            }
            this.satisfiedSignal.signalAll();
        }
        return stopErrors;
    }

    public void awaitSatisfaction() throws InterruptedException {
        while (!this.destroyed) {
            if (this.getUnsatisfied().isEmpty()) {
                return;
            }
            this.satisfiedSignal.await();
        }
    }
}

