/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceConditionContext;
import org.apache.xbean.kernel.ServiceName;

public class StandardServiceConditionContext
implements ServiceConditionContext {
    private final Kernel kernel;
    private final ServiceName serviceName;
    private final ClassLoader classLoader;
    private final Lock lock;
    private final Condition condition;
    private boolean satisfied = false;

    public StandardServiceConditionContext(Kernel kernel, ServiceName serviceName, ClassLoader classLoader, Lock lock, Condition condition) {
        this.kernel = kernel;
        this.serviceName = serviceName;
        this.classLoader = classLoader;
        this.lock = lock;
        this.condition = condition;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSatisfied() {
        this.lock.lock();
        try {
            if (!this.satisfied) {
                this.satisfied = true;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

