/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RIBulkChecker;

public abstract class ConstraintConstantAction
extends DDLSingleTableConstantAction {
    protected String constraintName;
    protected int constraintType;
    protected String tableName;
    protected String schemaName;
    protected UUID schemaId;
    protected IndexConstantAction indexAction;

    ConstraintConstantAction(String string, int n, String string2, UUID uUID, String string3, IndexConstantAction indexConstantAction) {
        super(uUID);
        this.constraintName = string;
        this.constraintType = n;
        this.tableName = string2;
        this.indexAction = indexConstantAction;
        this.schemaName = string3;
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public IndexConstantAction getIndexAction() {
        return this.indexAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void validateFKConstraint(TransactionController transactionController, DataDictionary dataDictionary, ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, ExecRow execRow) throws StandardException {
        GroupFetchScanController groupFetchScanController;
        GenericScanController genericScanController;
        block11: {
            block9: {
                block10: {
                    genericScanController = null;
                    groupFetchScanController = transactionController.openGroupFetchScan(foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, 7, 2, null, null, 1, null, null, -1);
                    try {
                        if (!groupFetchScanController.next()) {
                            groupFetchScanController.close();
                            Object var11_7 = null;
                            if (groupFetchScanController == null) break block9;
                            break block10;
                        }
                        groupFetchScanController.reopenScan(null, 1, null, null, -1);
                        genericScanController = transactionController.openGroupFetchScan(referencedKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, 6, 2, null, null, 1, null, null, -1);
                        RIBulkChecker rIBulkChecker = new RIBulkChecker((GroupFetchScanController)genericScanController, groupFetchScanController, execRow, true, null, null);
                        int n = rIBulkChecker.doCheck();
                        if (n > 0) {
                            StandardException standardException = StandardException.newException("X0Y45.S", (Object)foreignKeyConstraintDescriptor.getConstraintName(), (Object)foreignKeyConstraintDescriptor.getTableDescriptor().getName());
                            throw standardException;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var11_9 = null;
                        if (groupFetchScanController != null) {
                            groupFetchScanController.close();
                            groupFetchScanController = null;
                        }
                        if (genericScanController != null) {
                            genericScanController.close();
                            genericScanController = null;
                        }
                        throw throwable;
                    }
                }
                groupFetchScanController.close();
                groupFetchScanController = null;
            }
            if (genericScanController != null) {
                genericScanController.close();
                return;
            }
            return;
        }
        Object var11_8 = null;
        if (groupFetchScanController != null) {
            groupFetchScanController.close();
            groupFetchScanController = null;
        }
        if (genericScanController != null) {
            genericScanController.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateConstraint(String string, String string2, TableDescriptor tableDescriptor, LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*) FROM ");
        stringBuffer.append(tableDescriptor.getQualifiedName());
        stringBuffer.append(" WHERE NOT(");
        stringBuffer.append(string2);
        stringBuffer.append(")");
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
            resultSet = preparedStatement.execute(languageConnectionContext, false, 0L);
            ExecRow execRow = resultSet.getNextRow();
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            Number number = (Number)((NumberDataValue)execRow.getRowArray()[0]).getObject();
            if (number != null && number.longValue() != 0L) {
                if (bl) {
                    throw StandardException.newException("X0Y59.S", (Object)string, (Object)tableDescriptor.getQualifiedName(), (Object)number.toString());
                }
                boolean bl2 = false;
                return bl2;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return true;
    }
}

