/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.xml.QNameOrTokenAttr;
import org.w3c.dom.Element;

public class QNameOrTokenAnyAttrImpl
extends XMLAttrImpl
implements QNameOrTokenAttr {
    public boolean isQName() {
        return this.fContent instanceof QName;
    }

    public boolean isToken() {
        return !this.isQName() && this.isValid();
    }

    public QName getQName() {
        if (this.isQName()) {
            return (QName)this.fContent;
        }
        return null;
    }

    public String getToken() {
        if (!this.isQName() && this.isValid()) {
            return (String)this.fContent;
        }
        return null;
    }

    protected Object convert(Element element, String string) throws WSDLException {
        if ("#any".equals(string)) {
            return string;
        }
        WSDLException wSDLException = null;
        QName qName = null;
        if (string != null) {
            try {
                qName = DOMUtils.getQName(string, element);
            }
            catch (WSDLException wSDLException2) {
                wSDLException = wSDLException2;
            }
        }
        if (qName == null) {
            this.setValid(false);
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL507", new Object[]{string}, (short)2, (Exception)wSDLException);
        }
        return qName;
    }
}

