/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.drools;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.drools.DroolsComponent;
import org.drools.WorkingMemory;

public class JbiHelper {
    private DroolsComponent component;
    private MessageExchange exchange;
    private NormalizedMessage in;
    private WorkingMemory memory;

    public JbiHelper(DroolsComponent component, MessageExchange exchange, NormalizedMessage in, WorkingMemory memory) {
        this.component = component;
        this.exchange = exchange;
        this.in = in;
        this.memory = memory;
    }

    public void forwardToService(String uri, String localPart) throws MessagingException {
        QName service = new QName(uri, localPart);
        this.component.forwardToService(this.exchange, this.in, service);
    }

    public void forwardToService(QName name, QName operation, QName interfaceName) throws MessagingException {
        this.component.forwardToService(this.exchange, this.in, name);
    }

    public void invoke(QName service, QName operation, QName interfaceName) throws MessagingException {
        this.component.invoke(this.exchange, this.in, service, interfaceName, operation);
    }

    public void route(QName service, QName operation, QName interfaceName) throws MessagingException {
        this.component.route(this.exchange, this.in, service, interfaceName, operation);
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.getComponent().getContext().getDeliveryChannel();
    }

    public DroolsComponent getComponent() {
        return this.component;
    }

    public MessageExchange getExchange() {
        return this.exchange;
    }

    public NormalizedMessage getIn() {
        return this.in;
    }
}

